#include "char.h"
#include "game.h"

char const *spell_names[] = {
	"Invisibility",
	"Regeneration",
	"Teleport",
	"Shield",
	"Light",
	"Drift"
};

static int MAX[] = {
	1, 3, 1, 1, 3, 1
};

int
spell_cast (int id, SPELLTYPE s)
{
	if (list[id].spells[s].amount)
	{
		if (list[id].spells[s].active < MAX[s])
		{
			list[id].spells[s].amount--;
			list[id].spells[s].active++;
			message (FPS, s == SPELL_TELEPORT ? teleport : spell, 
				list[id].trapped?NULL:"%s spell cast!", spell_names[s]);
			/* Actual teleportation is handled elsewhere, so no need to do anything else here. */
			return 1;
		}
	}
	return 0;
}
