#include "game.h"
#include "map.h"
#include "message.h"

typedef struct ASSOCIATIVE ASSOCIATIVE;
struct ASSOCIATIVE
{
	char *str;
	int val;
	ASSOCIATIVE *next;
};
ASSOCIATIVE *ass_linked = NULL;

static void
ass_add (char *str, int val)
{
	ASSOCIATIVE *ass = malloc (sizeof *ass);
	ass->str = strdup (str);
	ass->val = val;
	ass->next = ass_linked;
	ass_linked = ass;
}

static void
ass_read (PACKFILE *file)
{
	char str[100];
	PACKFILE *chunk;
	chunk = pack_fopen_chunk (file, 0);
	while (!pack_feof (chunk))
	{
		int p;
		for (p = 0; (str[p] = pack_getc (chunk)); p++);
		ass_add (str, pack_igetl (chunk));
	}
	pack_fclose_chunk (chunk);
}

static void
ass_get (char const *str, int *ptr)
{
	ASSOCIATIVE *ass = ass_linked;
	for (; ass; ass = ass->next)
	{
		
		if (!strcmp (str, ass->str))
		{
			*ptr = ass->val;
			break;
		}
	}
}

static void
ass_clear (void)
{
	ASSOCIATIVE *ass = ass_linked, *next;
	for (; ass; ass = next)
	{
		next = ass->next;
		free (ass);
	}
	ass_linked = NULL;
}

#define save(var) \
	pack_fwrite (#var, strlen (#var), chunk); \
	pack_putc ('\0', chunk); \
	pack_iputl (var, chunk);

#define load(var) \
	ass_get (#var, &var);
	

static void
save_char (PACKFILE *file, int id)
{
	int type = list[id].type;
	PACKFILE *chunk;
	chunk = pack_fopen_chunk (file, 0);
	save (type);
	save (list[id].subtype);
	save (list[id].x);
	save (list[id].y);
	save (list[id].dx);
	save (list[id].dy);
	save (list[id].step);
	save (list[id].hit);
	save (list[id].alive);
	save (list[id].fighting);
	save (list[id].trapped);
	save (list[id].attacked);
	save (list[id].healing_time);
	save (list[id].delay);
	save (list[id].exp);
	save (list[id].next);
	save (list[id].lev);
	save (list[id].maxhit);
	save (list[id].dex);
	save (list[id].current_level);
	save (list[id].slain_foes[0]);
	save (list[id].slain_foes[1]);
	save (list[id].slain_foes[2]);
	save (list[id].slain_foes[3]);
	save (list[id].slain_foes[4]);
	save (list[id].slain_foes[5]);
	save (list[id].slain_foes[6]);
	save (list[id].slain_foes[7]);
	save (list[id].slain_foes[8]);
	save (list[id].slain_foes[9]);
	save (list[id].slain_foes[10]);
	save (list[id].slain_foes[11]);
	save (list[id].slain_foes[12]);
	save (list[id].slain_foes[13]);
	save (list[id].slain_foes[14]);
	save (list[id].slain_foes[15]);
	save (list[id].slain_foes[16]);
	save (list[id].slain_foes[17]);
	save (list[id].slain_foes[18]);
	save (list[id].slain_foes[19]);
	save (list[id].slain_foes[20]);
	save (list[id].deepest_level);
	save (list[id].potions);
	save (list[id].sacks);
	save (list[id].beacons);
	save (list[id].gold);
	save (list[id].weapon);
	save (list[id].map);
	save (list[id].sword);
	save (list[id].spells[0].amount);
	save (list[id].spells[0].active);
	save (list[id].spells[0].max);
	save (list[id].spells[1].amount);
	save (list[id].spells[1].active);
	save (list[id].spells[1].max);
	save (list[id].spells[2].amount);
	save (list[id].spells[2].active);
	save (list[id].spells[2].max);
	save (list[id].spells[3].amount);
	save (list[id].spells[3].active);
	save (list[id].spells[3].max);
	save (list[id].spells[4].amount);
	save (list[id].spells[4].active);
	save (list[id].spells[4].max);
	save (list[id].spells[5].amount);
	save (list[id].spells[5].active);
	save (list[id].spells[5].max);
	save (list[id].beaconx);
	save (list[id].beacony);
	save (list[id].sacrificed_gold);
	save (list[id].amulets_of_healing);
	save (list[id].amulets_of_light);

	pack_fclose_chunk (chunk);
}

static void
load_char (PACKFILE *file, int id)
{
	int type;
	
	memset (&list[id], 0, sizeof list[id]);
	
	ass_read (file);
	load (type);
	list[id].type = type;
	load (list[id].subtype);
	load (list[id].x);
	load (list[id].y);
	load (list[id].dx);
	load (list[id].dy);
	load (list[id].step);
	load (list[id].hit);
	load (list[id].alive);
	load (list[id].fighting);
	load (list[id].trapped);
	load (list[id].attacked);
	load (list[id].healing_time);
	load (list[id].delay);
	load (list[id].exp);
	load (list[id].next);
	load (list[id].lev);
	load (list[id].maxhit);
	load (list[id].dex);
	load (list[id].current_level);
	load (list[id].slain_foes[0]);
	load (list[id].slain_foes[1]);
	load (list[id].slain_foes[2]);
	load (list[id].slain_foes[3]);
	load (list[id].slain_foes[4]);
	load (list[id].slain_foes[5]);
	load (list[id].slain_foes[6]);
	load (list[id].slain_foes[7]);
	load (list[id].slain_foes[8]);
	load (list[id].slain_foes[9]);
	load (list[id].slain_foes[10]);
	load (list[id].slain_foes[11]);
	load (list[id].slain_foes[12]);
	load (list[id].slain_foes[13]);
	load (list[id].slain_foes[14]);
	load (list[id].slain_foes[15]);
	load (list[id].slain_foes[16]);
	load (list[id].slain_foes[17]);
	load (list[id].slain_foes[18]);
	load (list[id].slain_foes[19]);
	load (list[id].slain_foes[20]);
	load (list[id].deepest_level);
	load (list[id].potions);
	load (list[id].sacks);
	load (list[id].beacons);
	load (list[id].gold);
	load (list[id].weapon);
	load (list[id].map);
	load (list[id].sword);
	load (list[id].spells[0].amount);
	load (list[id].spells[0].active);
	load (list[id].spells[0].max);
	load (list[id].spells[1].amount);
	load (list[id].spells[1].active);
	load (list[id].spells[1].max);
	load (list[id].spells[2].amount);
	load (list[id].spells[2].active);
	load (list[id].spells[2].max);
	load (list[id].spells[3].amount);
	load (list[id].spells[3].active);
	load (list[id].spells[3].max);
	load (list[id].spells[4].amount);
	load (list[id].spells[4].active);
	load (list[id].spells[4].max);
	load (list[id].spells[5].amount);
	load (list[id].spells[5].active);
	load (list[id].spells[5].max);
	load (list[id].beaconx);
	load (list[id].beacony);
	load (list[id].sacrificed_gold);
	load (list[id].amulets_of_healing);
	load (list[id].amulets_of_light);
	
	/* Save-file compatibility */
	{
		int i = 0;
		ass_get ("slain_foes", &i);
		list[id].slain_foes[0] += i;
	}

	ass_clear ();
}


int
game_save (int nr)
{
	char name[256];
	PACKFILE *file;

	sprintf (name, "data/save%i.dat", nr);
	file = pack_fopen (name, "wp");
	
	if (file)
	{
		int i;
		int monster;
		PACKFILE *chunk = pack_fopen_chunk (file, 0);
		save (notrunning);
		save (won);
		save (gameover);
		save (spiral_map);
		save (swordrun);
		save (global_steps);
		save (char_num);
		monster = monster_count ();
		save (monster);
		save (monster_strength);
		save (monster_max);
		save (spawnpoints);
		save (spawnx[0]);
		save (spawny[0]);
		save (spawnx[1]);
		save (spawny[1]);
		save (spawnx[2]);
		save (spawny[2]);
		save (spawnx[3]);
		save (spawny[3]);
		save (spawnx[4]);
		save (spawny[4]);
		save (temple_x);
		save (temple_y);
		save (swordlev);
		save (mrand_seed);
		pack_fclose_chunk (chunk);
		for (i = 0; i < char_num; i++)
			save_char (file, i);
		
		chunk = pack_fopen_chunk (file, 0);
		map_save (chunk);
		pack_fclose_chunk (chunk);
		
		pack_fclose (file);
		
		sprintf (name, "data/save%i.html", nr);
		messages_exit (name);
		
		return 1;
	}
	return 0;
}

int
game_load (int nr)
{
	char name[256];
	PACKFILE *file;

	sprintf (name, "data/save%i.dat", nr);
	file = pack_fopen (name, "rp");

	if (file)
	{
		int i;
		int monster;
		PACKFILE *chunk;
		ass_read (file);
		load (notrunning);
		load (won);
		load (gameover);
		load (spiral_map);
		load (swordrun);
		load (global_steps);
		load (char_num);
		load (monster);
		monster_set_count (monster);
		load (monster_strength);
		load (monster_max);
		load (spawnpoints);
		load (spawnx[0]);
		load (spawny[0]);
		load (spawnx[1]);
		load (spawny[1]);
		load (spawnx[2]);
		load (spawny[2]);
		load (spawnx[3]);
		load (spawny[3]);
		load (spawnx[4]);
		load (spawny[4]);
		load (temple_x);
		load (temple_y);
		load (swordlev);
		load (mrand_seed);
		ass_clear ();
		for (i = 0; i < char_num; i++)
			load_char (file, i);

		chunk = pack_fopen_chunk (file, 0);
		map_load (chunk);
		pack_fclose_chunk (chunk);
		
		pack_fclose (file);
		
		sprintf (name, "data/save%i.html", nr);
		messages_init (name);
		return 1;
	}
	return 0;
}

int
game_delete (int nr)
{
	int ret = 1;
	char name[256];
	sprintf (name, "data/save%i.dat", nr);
	if (remove (name))
		ret = 0;
	sprintf (name, "data/save%i.html", nr);
	if (remove (name))
		ret = 0;
	return ret;
}
