#include "main.h"
#include "menu.h"
#include "game.h"
#include "gfx.h"
#include "map.h"
#include "scroller.h"
#include "credits.h"

int menu_active = 1;

static int update_main = 0;
static int update_top = 0;
static int update_bottom = 0;

static int menu_selected = 0;
char const **menu_text;
void (*menu) (int);

int menu_sub_selection[100];
int menu_sub_highlight = 0;
int ugly_hacking = 0;

static void menu_main (int);
char const *menu_main_text[] =
{
	"Start/Continue quest",
	" ",
	"Continue current quest",
	" ",
	"Delete a quest",
	" ",
	"Settings",
	" ",
	"Exit",
	NULL
};

static int selected_quest;
static int rolled_health, rolled_skill;
static char quest_string[256];
static char health_string[256];
static char skill_string[256];
static void menu_quest (int);
char const *menu_quest_text[] =
{
	" New quest ",
	" ",
	" Health ",
	" Skill ",
	" ",
	"Roll again, please",
	" ",
	"Begin quest: The Sword of Fargoal",
//	"Enhanced quest 1: The Helmet of Fargoal",
//	"Enhanced quest 2: Beyond the Dungeons of Fargoal ",
	" ",
	"Back",
	NULL
};


char savenames[9][100];

static void menu_new (int);
char const *menu_new_text[14];

static void menu_delete (int);
char const *menu_delete_text[14];

static void menu_settings (int);
char const *menu_settings_text[] =
{
	" Settings ",
	" ",
	"Display",
	" ",
	"Gameplay",
	" ",
	"Graphics style",
	" ",
	"Back",
	NULL
};

static void menu_display (int);
char const *menu_display_text[] =
{
	" Display Settings ",
	" ",
	"^Windowed^Fullscreen",
	" ",
	" Color depth ",
	"^8^15^16^24^32",
	" ",
	"Back",
	NULL
};

static void menu_gameplay (int);
char const *menu_gameplay_text[] =
{
	" Gameplay settings ",
	" ",
	"^Monster Movement:^Classic^Free",
	"^Monster Behavior:^Classic^Enhanced",
	"^Skill/HP balance:^Classic^Enhanced",
	"^Play Controls:^Classic^Enhanced",
	"^Fighting:^Classic^Adjacent",
	"^Dungeons:^Classic^Enhanced",
	"^Speed:^Classic^Enhanced",
	" ",
	"Back",
	NULL
};

static void menu_graphics (int);
char const *menu_graphics_text[] =
{
	" Graphics style ",
	" ",
	"Choose different scheme",
	"Toggle big sprites",
	"Custom configuration",
	" ",
	"Back",
	NULL
};

static void menu_customize (int);
char const *menu_customize_text[] =
{
	" Custom Configuration ",
	" ",
	"Different Layout",
	"Different Tileset",
	"Different Spriteset",
	" ",
	"Back",
	NULL
};

void
menu_alt_tab (void)
{
	update_top = 1;
	update_main = 1;
	update_bottom = 1;
}

static void
menu_selection (int dir)
{
	int os = menu_selected;
	if (dir == 1 || dir == -1)
	{
		do
		{
			menu_selected += dir;
			if (menu_selected < 0)
			{
				int i;
				for (i = 0; menu_text[i + 1]; i++);
				menu_selected = i;
			}
			if (!menu_text[menu_selected])
				menu_selected = 0;
		} while (menu_text[menu_selected][0] == ' ' && os != menu_selected);
	}

	if (menu_selected != os)
	{
		update_main = 1;
		if (!ugly_hacking)
			play_sample (step, 250, 128, 1000, 0);
	}
	menu_sub_highlight = 0;
}

static void
change_menu (void (*func) (int), char const **text)
{
	int t;
	menu = func;
	menu_text = text;
	update_main = 1;
	menu_selected = -1;
	menu_sub_highlight = 0;
	ugly_hacking = 1;
	for (t = 0; ; t++)
	{
		int o = menu_selected;
		menu(1);
		if (menu_selected < o)
			break;
	}
	ugly_hacking = 0;

	play_sample (human[1], 250, 128, 1000, 0);
}

static void
menu_main (int dir)
{
	if (dir)
	{
		menu_selection (dir);
		return;
	}
	switch (menu_selected)
	{
		case 0:
			change_menu (menu_new, menu_new_text);
			break;
		case 2:
			if (!notrunning)
			{
				game_continue ();
				menu_active = 0;
				break;
			}
			/* Fall through! */		
		case 4:
			change_menu (menu_delete, menu_delete_text);
			break;
		case 6:
			change_menu (menu_settings, menu_settings_text);
			break;
		case 8:
			run_exit ();
			break;
	}
}

static void
roll (void)
{	
	player_roll (&rolled_health, &rolled_skill);
	sprintf (health_string, " Health: %i ", rolled_health);
	menu_quest_text[2] = health_string;
	sprintf (skill_string, " Skill: %i ", rolled_skill);
	menu_quest_text[3] = skill_string;
	
	update_main = 1;
}

static void
menu_quest (int dir)
{
	if (dir)
	{
		menu_selection (dir);
		return;
	}
	switch (menu_selected)
	{
		case 5:
			roll ();
			break;
		case 7:
		{			
			char str[100];
			char entry[100];

			quest_number = selected_quest;
					
			message (FPS / 2, NULL, "Quest %i selected!!", menu_selected - 1);

			set_config_file ("data/settings.cfg");
			sprintf (str, "data/save%i.dat", quest_number);
			sprintf (entry, "Beginning");

			set_config_string ("SOF", str, entry);
			sprintf (savenames[quest_number - 1], "%i: %s", quest_number, entry);
			update_main = 1;
			
			sprintf (quest_string, " New quest: %s ", entry);
			menu_quest_text[0] = quest_string;
			
			game_original (rolled_health, rolled_skill);
			menu_active = 0;
			break;
		}
		/*case 8:
			game_original ();
			menu_active = 0;
		break;
		case 9:
			game_original ();
			menu_active = 0;
		break;*/
		case 9:
			change_menu (menu_main, menu_main_text);
		break;
	}
}

static void
menu_new (int dir)
{
	if (dir)
	{
		menu_selection (dir);
		return;
	}
	if (menu_selected >= 2 && menu_selected <= 10)
	{
		char str[100];
		set_config_file ("data/settings.cfg");
		sprintf (str, "data/save%i.dat",	menu_selected - 1);
		
		if (!get_config_string ("SOF", str, NULL))
		{
			roll ();
			selected_quest = menu_selected - 1;
			change_menu (menu_quest, menu_quest_text);
			menu_selected = 7;
		}
		else
		{
			if (game_load (menu_selected - 1))
			{
				quest_number = menu_selected - 1;
				message (FPS / 2, NULL, "Quest %i loaded!!", menu_selected - 1);
				game_continue ();
				menu_active = 0;
			}
			else
				message (FPS / 2, NULL, "Could not load!!");
		}
	}
	else
	{
		change_menu (menu_main, menu_main_text);
		menu_selected = 2;
	}
}

static void
menu_delete (int dir)
{
	if (dir)
	{
		menu_selection (dir);
		return;
	}
	if (menu_selected >= 2 && menu_selected <= 10)
	{
		char str[100];
		set_config_file ("data/settings.cfg");
		sprintf (str, "data/save%i.dat", menu_selected - 1);
		if (game_delete (menu_selected - 1) ||
			get_config_string ("SOF", str, NULL))
		{
			message (FPS / 2, NULL, "Quest %i removed!!", menu_selected - 1);
			sprintf (savenames[menu_selected - 2], "%i: empty", menu_selected - 1);
			set_config_string ("SOF", str, NULL);
			update_main = 1;
		}
		else
		{
			message (FPS / 2, NULL, "Nothing to remove!!");
		}
		
	}
	else
	{
		change_menu (menu_main, menu_main_text);
		menu_selected = 2;
	}
}

static int
get_cd_num (int cd)
{
	return cd / 8 - (cd == 8);
}

static void
menu_settings (int dir)
{
	if (dir)
	{
		menu_selection (dir);
		return;
	}
	if (menu_selected == 2)
	{
		change_menu (menu_display, menu_display_text);
		return;
	}
	if (menu_selected == 4)
	{
		change_menu (menu_gameplay, menu_gameplay_text);
		return;
	}
	if (menu_selected == 6)
	{
		change_menu (menu_graphics, menu_graphics_text);
		return;
	}
	change_menu (menu_main, menu_main_text);
	menu_selected = 2;
}

static void
menu_gameplay (int dir)
{
	int *vars[] =
	{
		&extensions_nomonsterpause,
		&extensions_monsteraction,
		&extensions_balance,
		&extensions_controls,
		&extensions_overlapfight,
		&extensions_dungeons,
		&extensions_speed
	};
	if (dir == 1 || dir == -1)
	{
		menu_selection (dir);
		if (menu_selected != 10)
			menu_sub_highlight = 1 + *vars[menu_selected - 2];
		menu_sub_selection[menu_selected] = menu_sub_highlight;
		return;
	}
	if (menu_selected != 10)
	{
		*vars[menu_selected - 2] = !*vars[menu_selected - 2];
		menu_sub_selection[menu_selected] = 1 + *vars[menu_selected - 2];
		update_main = 1;
		message (FPS / 2, NULL, "Gameplay settings changed");
		menu_sub_highlight = menu_sub_selection[menu_selected];
		return;
	}
	if (!dir)
	{
		change_menu (menu_settings, menu_settings_text);
		menu_selected = 4;
	}
}


static void
menu_display (int dir)
{
	if (dir == 1 || dir == -1)
	{
		menu_selection (dir);
		if (menu_selected == 5)
			menu_sub_highlight = get_cd_num (colordepth);
		if (menu_selected == 2)
			menu_sub_highlight = fullscreen;
		menu_sub_selection[menu_selected] = menu_sub_highlight;
		return;
	}
	if (menu_selected == 2)
	{
		if (dir)
		{
			menu_sub_highlight = (menu_sub_highlight + dir / 2) & 1;
			update_main = 1;
			return;
		}
		if (set_gfx_mode (menu_sub_highlight ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0))
		{
			set_gfx_mode (fullscreen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
			message (FPS / 2, NULL, "Cannot use %s mode with the current color depth", menu_sub_selection[menu_selected] ? "fullscreen" : "windowed");			
		}
		else
		{
			fullscreen = menu_sub_selection[menu_selected];
			message (FPS / 2, NULL, "Changed to %s", fullscreen ? "fullscreen" : "windowed");
			menu_sub_selection[menu_selected] = menu_sub_highlight;
		}
		fix_alt_tab ();
		{
			if (colordepth == 8)
			{
				PALETTE pal;
				generate_332_palette (pal);
				memset (&pal[0], 0, sizeof pal[0]);
				set_palette (pal);
			}
			update_top = 1;
			update_main = 1;
			update_bottom = 1;
		}
		return;
	}
	if (menu_selected == 5)
	{
		if (dir)
		{
			menu_sub_highlight = MAX (0, MIN (4, menu_sub_highlight + dir / 2));
			update_main = 1;
		}
		else
		{
			int cds[] = {8, 15, 16, 24, 32};
			int cd = cds[menu_sub_highlight];
			set_color_depth (cd);
			if (set_gfx_mode (fullscreen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0))
			{
				set_color_depth (colordepth);
				set_gfx_mode (fullscreen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
				message (FPS / 2, NULL, "Cannot use color depth %i in %s mode", cd,
					fullscreen ? "fullscreen" : "windowed");
			}
			else
			{
				menu_sub_selection[menu_selected] = menu_sub_highlight;
				colordepth = cd;
				message (FPS / 2, NULL, "Colordepth set to %i", cd);
			}
			fix_alt_tab ();
			if (cd == 8)
			{
				PALETTE pal;
				generate_332_palette (pal);
				memset (&pal[0], 0, sizeof pal[0]);
				set_palette (pal);
			}
			update_top = 1;
			update_main = 1;
			update_bottom = 1;
			graphics_init ();
			destroy_bitmap (page);
			page = create_bitmap (SCREEN_W, SCREEN_H);
		}
		return;
	}
	if (dir == 0)
	{
		change_menu (menu_settings, menu_settings_text);
		menu_selected = 2;
	}
}

static void
scheme_selection (int dir, int *s, char const *str)
{
	char section[256];
	*s += dir == -2 ? -1 : 1;
	set_config_file ("data/sof.cfg");
	if (*s < 0)
	{
		for (*s = 1; ; (*s)++)
		{
			sprintf (section, "scheme%i", *s);
			if (!get_config_string (section, str, NULL))
			{
				(*s)--;
				break;
			}
		}
	}
	sprintf (section, "scheme%i", *s);
	if (!get_config_string (section, str, NULL))
	{
		*s = 0;
	}
}

static void
menu_graphics (int dir)
{
	if (dir == 1 || dir == -1)
	{
		menu_selection (dir);
		return;
	}
	if (menu_selected == 2)
	{
		scheme_selection (dir, &scheme, "name");
		charset = scheme;
		tileset = scheme;
		layout = scheme;
		update_top = 1;
		update_main = 1;
		update_bottom = 1;
		graphics_init ();
		message (FPS / 2, 0, "Scheme %i", scheme);
		return;
	}
	if (menu_selected == 3)
	{
		doublesize = !doublesize;
		update_main = 1;
		graphics_init ();
		message (FPS / 2, 0, "Switched big sprites %s",
			doublesize ? "on" : "off");
		return;
	}
	if (menu_selected == 4)
	{
		if (dir == 0)
			change_menu (menu_customize, menu_customize_text);
		return;
	}
	if (!dir)
	{
		change_menu (menu_settings, menu_settings_text);
		menu_selected = 6;
	}
}

static void
menu_customize (int dir)
{
	if (dir == 1 || dir == -1)
	{
		menu_selection (dir);
		return;
	}

	if (menu_selected == 4)
	{
		scheme_selection (dir, &charset, "sprites");
		graphics_init();
		message (FPS / 2, 0, "Sprites %i", charset);
		update_main = 1;
		return;
	}
	if (menu_selected == 3)
	{
		scheme_selection (dir, &tileset, "tileset");
		graphics_init();
		message (FPS / 2, 0, "Tileset %i", tileset);
		update_main = 1;
		return;
	}
	if (menu_selected == 2)
	{
		update_top = 1;
		update_main = 1;
		update_bottom = 1;
		scheme_selection (dir, &layout, "layout");
		graphics_init();
		message (FPS / 2, 0, "Layout %i", layout);
		return;
	}

	if (!dir)
	{
		change_menu (menu_settings, menu_settings_text);
		menu_selected = 6;
	}
}

void
menu_init (void)
{
	int i;
	char str[100];

	set_config_file ("data/settings.cfg");
	
	if (!notrunning)
	{
		char entry[100];
		sprintf (entry, "Dungeon %i, Level %i, %s",
			list[1].current_level, list[1].lev,
			won ? "won" : gameover ? "dead" : swordrun ? "running out of time" : "alive");
		game_save (quest_number);
		sprintf (str, "data/save%i.dat", quest_number);
		set_config_string ("SOF", str, entry);
	}

	for (i = 0; i < 9; i++)
	{
		char const *entry;
		sprintf (str, "data/save%i.dat",	i + 1);
		entry = get_config_string ("SOF", str, "empty");
		sprintf (savenames[i], "%i: %s", i + 1, entry);
		menu_delete_text[2 + i] = savenames[i];
		menu_new_text[2 + i] = savenames[i];
	}
	menu_delete_text[0] = " Delete Quest ";
	menu_delete_text[1] = " ";
	menu_delete_text[11] = " ";
	menu_delete_text[12] = "Back";
	menu_delete_text[13] = NULL;
		
	menu_new_text[0] = " Select a spot ";
	menu_new_text[1] = " ";
	menu_new_text[11] = " ";
	menu_new_text[12] = "Back";
	menu_new_text[13] = NULL;
	
	update_top = 1;
	update_main = 1;
	update_bottom = 1;
	menu_text = menu_main_text;
	menu = menu_main;
	menu_selected = 0;
	
	credits_init ();
	
	if (!notrunning && !won && !gameover)
	{
		menu_selected = 2;
		message (FPS / 2, NULL, "Thy quest is interrupted!!");
	}
	else
	{
		/* Need something for the initial DR. */
		if (won)
		{
			message (FPS / 2, NULL, "You won!!");
		}
		else
		if (gameover)
		{
			message (FPS / 2, NULL, "You lost!!");
		}
		else
		message (FPS / 2, NULL, "Welcome!");
	}
}

void
menu_run (void)
{
	if (check_key (KEY_ENTER) || check_key (KEY_LCONTROL))
	{
		menu (0);	
	}
	if (check_key (KEY_LEFT))
	{
		menu (-2);
	}
	if (check_key (KEY_RIGHT))
	{
		menu (2);
	}
	if (check_key (KEY_DOWN))
	{
		menu (1);
	}
	if (check_key (KEY_UP))
	{
		menu (-1);
	}
	messages_update ();
	if (credits_scroll ())
		update_top = 1;
}



void
menu_render (void)
{
	messages_render ();
	
	if (update_top)
	{
		blit (title, page, 0, 18, 0, 18, SCREEN_W, 72);
		credits_render ();
	}
	
	if (update_main)
	{
		int i;
		int x = 0, y = 0;
		blit (title, page, 0, 90, 0, 90, SCREEN_W, 300);
		text_mode (-1);
		for (i = 0; menu_text[i]; i++)
		{
			int w;
			char const *ptr = menu_text[i];
			int show_selection = 0;
			int j;
			int img = 0;
			if (*ptr >= '1' && *ptr <= '9')
			{
				img = *ptr - '0';
			}
			if (*ptr == '^')
			{
				show_selection = 1;
				ptr++;
			}
			w = text_length (font, ptr);
			x = (SCREEN_W - w) / 2;
			if (img)
			{
				draw_sprite (page, anims[img], x - 10 - sprite_w,
					120 + y + text_height (font) / 2 - sprite_h / 2);
			}
			for (j = 0; ; j++)
			{
				char str[256];
				int color;
				char *next = strchr (ptr + 1, '^');
				if (next)
					ustrzncpy (str, 256, ptr, next - ptr);
				else
					ustrzcpy (str, 256, ptr);
				
				if (menu_text[i][0] == ' ')
					color = layout_color (LC_TITLE);
				else
					color = menu_selected == i && menu_sub_highlight == j ?
					layout_color (LC_HIGHLIGHT) : show_selection &&
					menu_sub_selection[i] == j ? layout_color (LC_SELECTED) :
					layout_color (LC_MENU);
				
				textprintf (page, font, x, 120 + y,	color, "%s", str);
				x += text_length (font, str) + text_length (font, "^");
				if (next)
					ptr = next + 1;
				else
					break;
			}
			
			y += 20;
		}
		if (menu == menu_graphics || menu == menu_customize)
		{
			int xp = SCREEN_W / 2 - 7 * tw / 2;
			int yp = 300;
			// Draw small sample
			for (y = 0; y < 7; y++)
			{
				for (x = 0; x < 7; x++)
				{
					// This kind of code drives me insane - PP
					masked_blit (tileset_bmp, page,
						x > 0 && y > 0 && x < 6 && y < 6 ?
						x > 1 && y > 1 && x < 5 && y < 5 ?
						tw : tw * 2 : tw,
						0, xp + x * tw, yp + y * th - th, tw, th * 2);
				}
			}

			masked_blit (charset_bmp, page, 0, 0, xp + tw * 7 / 2 - sprite_w / 2,
				yp + 4 * th - sprite_h, sprite_w, sprite_h);
			
			if (menu == menu_graphics)
			{
				textprintf_centre (page, font, SCREEN_W / 2, 276,
					layout_color (LC_HELP),	"\"%s\"%s", scheme_name,
						doublesize ? " (2 x)" : "");
			}
			else
			{
				textprintf_centre (page, font, SCREEN_W / 2, 276,
					layout_color (LC_HELP),	
						(menu_selected>=2&&menu_selected<=4)?
						"\"%s\"%s":"%s%s",
						menu_selected == 4 ? charset_name :
						menu_selected == 3 ? tileset_name :
						menu_selected == 2 ? layout_name : "",
						menu_selected == 4 && doublesize ? " (2x)" : "");

			}
		}
		if (menu == menu_display)
		{
			if (menu_selected == 5)
				textprintf_centre (page, font, SCREEN_W / 2, 300, layout_color (LC_HELP),
					"Current depth: %i", colordepth);
			if (menu_selected == 2)
				textprintf_centre (page, font, SCREEN_W / 2, 300, layout_color (LC_HELP),
					"Currently: %s mode", fullscreen ? "fullscreen" : "windowed");
		}
		if (menu == menu_gameplay)
		{
			textprintf_centre (page, font, SCREEN_W / 2, 350,
				layout_color (LC_HELP),	"%s",			
				menu_selected == 2 ? "Paused or unpaused monster turns" :
				menu_selected == 3 ? "whether mages/demons disappear, and monsters move when not near" :
				menu_selected == 4 ? "Random or monster-skill based skill advancement/and more HP" :
				menu_selected == 5 ? "Fargoal or Roguelike controls" :
				menu_selected == 6 ? "Overlapped fights, or not" :
				menu_selected == 7 ? "Allow check for getting stuck, and custom levels" :
				menu_selected == 8 ? "Original or fast movement speed" :
				"");
		}

	}
	
	if (update_bottom)
	{
		blit (title, page, 0, SCREEN_H - 90, 0, SCREEN_H - 90, SCREEN_W, 90);
		textprintf_right (page, font, SCREEN_W - 5, SCREEN_H - 5 - 8,
			layout_color (LC_HELP), "remakes.org");
	}
	
	if (USE_DRS)
	{
		if (messages_updated ())
		{
			blit (page, screen, 0, 0, 0, 0, SCREEN_W, 18);
		}
		if (update_top)
		{
			blit (page, screen, 0, 18, 0, 18, SCREEN_W, 72);
			update_top =0 ;
		}
		if (update_main)
		{
			blit (page, screen, 0, 90, 0, 90, SCREEN_W, 300);
			update_main = 0;
		}
		if (update_bottom)
		{
			blit (page, screen, 0, SCREEN_H - 90, 0, SCREEN_H - 90, SCREEN_W, 90);
			update_bottom =0 ;
		}
	}
	else
	{
		blit (page, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}
}
