#ifndef _CHAR_H_
#define _CHAR_H_

#include "main.h"
#include "spell.h"
#include "player.h"
#include "monster.h"

#define CHAR_NUM 21
//#define MAX_CHARS 100
#define MAX_CHARS 10

typedef enum TYPE TYPE;
typedef struct TEMP TEMP;
typedef struct CHAR CHAR;

/* Character type. */
enum TYPE
{
	CHAR_HERO,

	CHAR_ROGUE,
	CHAR_BARBARIAN,
	CHAR_ELVE,
	CHAR_DWARF,
	CHAR_MERCENARY,
	CHAR_SWORDSMAN,
	CHAR_MONK,
	CHAR_DARKWARRIOR,
	CHAR_ASSASSIN,
	CHAR_WARLORD,

	CHAR_DIREWOLF,
	CHAR_OGRE,
	CHAR_HOBGOBLIN,
	CHAR_WEREBEAR,
	CHAR_GARGOYLE,
	CHAR_TROLL,
	CHAR_WYVERN,
	CHAR_SPIDER,
	CHAR_DRAGON,
	CHAR_DRAKE
};

/* Character state. */
struct CHAR
{
	TYPE type;
	int subtype;

	int x, y;
	int dx, dy;					/* direction */
	int step;					/* animation step */

	int hit;					/* current_hitpoints */

	/* Some state variables: */
	int alive;					/* Character is alive. */
	int fighting;				/* Character is fighting. */
	int trapped;				/* Character is inside a trap. */
	int attacked;				/* Character is being attacked. */

	int healing_time;           /* Counter. */

	int delay;					/* Character is sleeping. */

	int exp;					/* Current experience points. */
	int next;					/* Exp. points needed to level up. */
	int lev;					/* Current level. */
	int maxhit;					/* Maximum hitpoints. */
	int dex;					/* Fighting skill. */
	int current_level;			/* Current dungeon level. */

	/* Statisitcs. */
	int slain_foes[CHAR_NUM];
	int deepest_level;

	/* Inventory. */
	int potions;
	int sacks;
	int beacons;
	int gold;
	int weapon;
	int map;                    /* Bit field of maps. */
	int sword;                  /* The sword of fargoal. */

	SPELL spells[6];			/* Spellbook. */
	int beaconx, beacony;		/* Position of beacon. */
	int sacrificed_gold;
	int amulets_of_healing;
	int amulets_of_light;
};

extern CHAR list[MAX_CHARS];
extern int char_num;
extern char const *char_names[CHAR_NUM];
extern char const *char_prefixes[CHAR_NUM][3];

void chars_init (void);
int char_create (int x, int y);
int char_move (int id, int dx, int dy);
int char_teleport (int id);
void char_transfer_to (int id, int x, int y);

#endif
