#include "main.h"
#include "game.h"
#include "gfx.h"

static FILE *messagefile = NULL;

typedef struct MESSAGE MESSAGE;
struct MESSAGE
{
	int delay;
	SAMPLE *sound;
	int volume, pitch, panning;
	char string[100];
};

static MESSAGE messages[10] = { {0, NULL, 0, 0, 0, ""} };
static int message_rotate = 0;
static int message_current = 0;
static int message_time = 0;
static int message_idle = 0;
static int message_render = 0;

static void
file_copy (char const *src, char const *dst, int html)
{
	FILE *file_src;
	long s;
	s = file_size (src);
	file_src = fopen (src, "rb");
	if (file_src)
	{
		FILE *file_dst;
		file_dst = fopen (dst, "wb");		
		if (file_dst)
		{
			char *buf;
			buf = malloc (s);
			fread (buf, 1, s, file_src);
			
			if (html)
			{
				fprintf (file_dst, "<html><body><pre>\n");
			}
			else
			{
				char *start, *end;
				start = strstr (buf, "<pre>");
				if (start)
				{
					buf = start + 5;
					while (*buf < ' ')
						buf++;

					end = strstr (buf, "</pre>");
					if (end)
					{
						s = end - buf;
					}
					
				}
				
			}
			fwrite (buf, 1, s, file_dst);
			if (html)
			{
				fprintf (file_dst, "</pre></body></html>");
			}
			fclose (file_dst);
		}
		fclose (file_src);
	}
}

void
messages_init (char const *filename)
{
	if (messagefile)
		fclose (messagefile);
	
	if (filename)
	{
		file_copy (filename, "data/last.log", 0);
		messagefile = fopen ("data/last.log", "a");
	}
	else
		messagefile = fopen ("data/last.log", "w");
}

/* Copy current messages to given file. */
void
messages_exit (char const *filename)
{
	if (messagefile)
		fclose (messagefile);
	
	file_copy ("data/last.log", filename, 1);
	
	messagefile = fopen ("data/last.log", "a");
}

static void
_message (int delay, SAMPLE * sound, int volume, int pitch, int panning, char *str)
{
	message_rotate++;

	if (message_rotate == 10)
		message_rotate = 0;

	messages[message_rotate].string[0] = '\0';
	messages[message_rotate].delay = delay;
	messages[message_rotate].sound = sound;
	messages[message_rotate].volume = volume;
	messages[message_rotate].pitch = pitch;
	messages[message_rotate].panning = panning;
	paused += delay;
	
	if (str)
	{
		strcpy (messages[message_rotate].string, str);
		strcat (messages[message_rotate].string, "   ");
		update_stats ();
		if (messagefile)
			fprintf (messagefile, "%s\n", messages[message_rotate].string);
	}
}

void
message_ex (int delay, SAMPLE * sound, int volume, int pitch, int panning, char const *format, ...)
{
	if (format)
	{
		char str[100];
		va_list arg;
		va_start (arg, format);
		vsnprintf (str, 100, format, arg);
		va_end (arg);
		_message (delay, sound, volume, pitch, panning, str);
	}
	else
		_message (delay, sound, volume, pitch, panning, NULL);
}

void
message (int delay, SAMPLE * sound, char const *format, ...)
{
	if (format)
	{
		char str[100];
		va_list arg;
		va_start (arg, format);
		vsnprintf (str, 100, format, arg);
		va_end (arg);
		_message (delay, sound, 0, 0, 0, str);
	}
	else
		_message (delay, sound, 0, 0, 0, NULL);
}

void
messages_update (void)
{
	if (message_time > 0)
	{
		message_render = 1;
		message_time--;			
	}
	else if (message_current != message_rotate)
	{
		MESSAGE *m;
		message_current++;
		if (message_current == 10)
			message_current = 0;

		m = &messages[message_current];
		
		message_time = messages[message_current].delay;
		message_idle = 0;
		message_render = 1;
		
		if (messages[message_current].sound)
			play_sample (messages[message_current].sound,
				250 - rnd (0, m->volume),
				128 + rnd (-m->panning, m->panning),
				1000 + rnd (-m->pitch, m->pitch * 2), 0);
	}
	else
	{
		message_idle++;
		if (message_idle > FPS * 4 && messages[message_current].string[0])
		{
			message (FPS / 2, NULL, NULL);
			paused -= FPS / 2;
		}
	}
}

void
messages_render (void)
{
	if (message_render)
	{
		int p = message_current - 1;
		int l;
		int f = FPS / 2;
		int m = message_time;

		if (m > f)
			m = f;
		if (p < 0)
			p = 9;

		l = text_length (font, messages[p].string);
		blit (title, page, 0, 0, 0, 0, SCREEN_W, 18);
		text_mode (-1);
		if (m)
			textout_right (page, font, messages[p].string, 4 + l * m / f, 4, layout_color (LC_MESSAGE));
		textout (page, font, messages[message_current].string, 4 + l * m / f, 4, layout_color (LC_MESSAGE));
	}
}

int
messages_updated (void)
{
	return message_render;
}
