#include "main.h"
#include "map.h"
#include "gfx.h"

BITMAP *tiles[TILE_NUM];
BITMAP *anims[CHAR_NUM];

BITMAP *title = NULL;
BITMAP *tileset_bmp = NULL;
BITMAP *charset_bmp = NULL;

int layout = 0;
int tileset = 0;
int charset = 0;
int scheme = 0;
int doublesize = 0;


char scheme_name[100];
char tileset_name[100];
char charset_name[100];
char layout_name[100];

int sprite_w, sprite_h;

static BITMAP *
load_8bit (char const *name)
{
	PALETTE pal;
	BITMAP *bmp = load_bitmap (name, pal);
	if (!bmp)
		return NULL;
	if (bitmap_color_depth (screen) == 8)
	{
		BITMAP *tmp = create_bitmap_ex (32, bmp->w, bmp->h);
		select_palette (pal);
		blit (bmp, tmp, 0, 0, 0, 0, bmp->w, bmp->h);
		unselect_palette ();
		generate_332_palette (pal);
		select_palette (pal);
		blit (tmp, bmp, 0, 0, 0, 0, bmp->w, bmp->h);
		unselect_palette ();
		destroy_bitmap (tmp);
	}
	return bmp;
}

static int colors[COLOR_COUNT];

int
layout_color (int n)
{
	return colors[n];
}

static void
read_layout_colors (char const *name)
{
	char const *color_names[] =
	{
		"color_title",		
		"color_menu",
		"color_selected",
		"color_message",
		"color_help",
		"color_gold",
		"color_healthy",
		"color_health",
		"color_hurt",
		"color_stats",
		"color_info",
		"color_dungeon",
		"color_empty",
		"color_beacons",
		"color_beacon",
		"color_sacks",
		"color_potions",
		"color_nopotions",
		"color_nospell",
		"color_spell",
		"color_cast",
		"color_time",
		"color_blink",
		"color_highlight"
	};
	int i;
	for (i = 0; i < COLOR_COUNT; i++)
	{
		char const *rgb = get_config_string (name, color_names[i], "#ffffff");
		int v = strtol (rgb + 1, NULL, 16);
		colors[i] = makecol (v >> 16, (v >> 8) & 255, v & 255);
	}
};

int
graphics_init (void)
{
	int i;
	char const *name;
	char section[256];

	if (!exists ("data/sof.cfg"))
	{
		printf ("Cannot find data/sof.cfg.\n");
		return 1;
	}
	set_config_file ("data/sof.cfg");

	sprintf (section, "scheme%i", tileset);
	strcpy (scheme_name, get_config_string (section, "name", "default"));

	name = get_config_string (section, "tileset", "gfx/tiles.bmp");

	strcpy (tileset_name, get_config_string (section, "name", "default"));
	if (tileset_bmp)
		destroy_bitmap (tileset_bmp);
	tileset_bmp = load_8bit (name);
	if (!tileset_bmp)
	{
		printf ("Could not find %s.\n", name);
		return 1;
	}
	for (i = 0; i < TILE_NUM; i++)
	{
		if (tiles[i])
			destroy_bitmap (tiles[i]);
		tiles[i] = create_sub_bitmap (tileset_bmp, i * 16, 0, 16, 24);
	}
	
	sprintf (section, "scheme%i", charset);
	name = get_config_string (section, "sprites", "gfx/chars.bmp");
	strcpy (charset_name, get_config_string (section, "name", "default"));
	if (charset_bmp)
		destroy_bitmap (charset_bmp);
	charset_bmp = load_8bit (name);
	if (!charset_bmp)
	{
		printf ("Could not find %s.\n", name);
		return 1;
	}
	if (doublesize)
	{
		BITMAP *bmp = create_bitmap (charset_bmp->w * 2, charset_bmp->h * 2);
		stretch_blit (charset_bmp, bmp, 0, 0, charset_bmp->w, charset_bmp->h,
			0, 0, charset_bmp->w * 2, charset_bmp->h * 2);
		destroy_bitmap (charset_bmp);
		charset_bmp = bmp;
	}
	sprite_w = charset_bmp->w / 21;
	sprite_h = charset_bmp->h;
	for (i = 0; i < CHAR_NUM; i++)
	{
		if (anims[i])
			destroy_bitmap (anims[i]);
		anims[i] = create_sub_bitmap (charset_bmp, i * sprite_w, 0, sprite_w, sprite_h);
	}
	
	sprintf (section, "scheme%i", layout);
	name = get_config_string (section, "layout", "gfx/layout.bmp");

	read_layout_colors (section);
	strcpy (layout_name, get_config_string (section, "name", "default"));
	if (title)
		destroy_bitmap (title);
	title = load_8bit (name);
	if (!title)
	{
		printf ("Could not find %s.\n", name);
		return 1;
	}
	
	return 0;
}
