#include "game.h"
#include "menu.h"
#include "config.h"
#include "gfx.h"

void
save_settings (void)
{
	set_config_file ("data/settings.cfg");
	set_config_int ("SOF", "colordepth", colordepth);
	set_config_int ("SOF", "fullscreen", fullscreen);
	set_config_int ("SOF", "scheme", scheme);
	set_config_int ("SOF", "tileset", tileset);
	set_config_int ("SOF", "charset", charset);
	set_config_int ("SOF", "doublesize", doublesize);
	set_config_int ("SOF", "layout", layout);
	set_config_int ("SOF", "extensions_nomonsterpause", extensions_nomonsterpause);
	set_config_int ("SOF", "extensions_balance", extensions_balance);
	set_config_int ("SOF", "extensions_monsteraction", extensions_monsteraction);
	set_config_int ("SOF", "extensions_controls", extensions_controls);
	set_config_int ("SOF", "extensions_overlapfight", extensions_overlapfight);
	set_config_int ("SOF", "extensions_dungeons", extensions_dungeons);
	set_config_int ("SOF", "extensions_speed", extensions_speed);
	set_config_int ("SOF", "current_quest", quest_number);
}

void
load_settings (void)
{
	set_config_file ("data/settings.cfg");
	colordepth = get_config_int ("SOF", "colordepth", desktop_color_depth ());
	fullscreen = get_config_int ("SOF", "fullscreen", 0);
	scheme = get_config_int ("SOF", "scheme", 0);
	tileset = get_config_int ("SOF", "tileset", 0);
	charset = get_config_int ("SOF", "charset", 0);
	doublesize = get_config_int ("SOF", "doublesize", 0);
	layout = get_config_int ("SOF", "layout", 0);
	extensions_nomonsterpause = get_config_int ("SOF", "extensions_nomonsterpause", 1);
	extensions_balance = get_config_int ("SOF", "extensions_balance", 1);
	extensions_monsteraction = get_config_int ("SOF", "extensions_monsteraction", 1);
	extensions_controls = get_config_int ("SOF", "extensions_controls", 1);
	extensions_overlapfight = get_config_int ("SOF", "extensions_overlapfight", 1);
	extensions_dungeons = get_config_int ("SOF", "extensions_dungeons", 1);
	extensions_speed = get_config_int ("SOF", "extensions_speed", 1);
	quest_number = get_config_int("SOF", "current_quest", 0);
}
