#include "main.h"
#include "gfx.h"
#include "credits.h"

static int credits_scrolling;
static int credits_pos, credits_prev;
static int credits_ticker;
static const char *credits[] =
{
	"",
	"Check out the 'Game Settings' menu to experience either Classic...",
	"...or Enhanced play options for Sword of Fargoal!",
	"Sword of Fargoal was created by Jeff McCord",
	"released by Epyx in 1983",
	"remade in cooperation of",
	"SAKFU-Soft and Allefant-Games",
	"remake created by",
	"Paul Pridham and Elias Pschernig",
	"additional artwork by",
	"Dan MacDonald",
	"Zooey Ball",
	"thanks for playtesting",
	"Angelo Mottola",
	"Brigham Toskin",
	"Johan Peitz",
	"Lennart Steinke",
	"SpawnPPC",
	"from allegro.cc forums:",
	"23yrold3yrold",
	"Matthew Leverton",
	"Peter Hull",
	"Sirocco",
	"from YakYak forums:",
	"Andy H",
	"Black",
	"fflip",
	"moobaa",
	"mutopian",
	"special thanks to",
	"remakes.org",
	"Jeff McCord (made a great game!)",
	"Allegro developers (for providing a great lib!)",
	"Allegro mailing lists contributors",
	"Shawn Hargreaves (mandatory in all my credits lists)",
	"",
	NULL
};

void
credits_init (void)
{
	credits_prev = 0;
	credits_pos = 0;
	credits_scrolling = 0;
	credits_ticker = FPS * 2;
}

int
credits_scroll (void)
{
	int update = credits_scrolling;
	if (credits_scrolling)
	{
		credits_scrolling--;
	}
	else if (credits_ticker)
	{
		credits_ticker--;
	}
	else
	{
		credits_scrolling = FPS;
		credits_ticker = FPS * 3;
		credits_prev = credits_pos;
		credits_pos++;
		if (!credits[credits_pos])
			credits_pos = 0;
	}
	return update;
}

void
credits_render (void)
{
	int x, y;
	text_mode (-1);

	textprintf_centre (page, font,
		SCREEN_W / 2, 40,
		layout_color (LC_TITLE),
		"The Sword of Fargoal!!");
	
	if (credits_scrolling)
	{
		double v = (1.0 - (double)credits_scrolling / (double)FPS);
		y = text_height (font) * (sin (-v * AL_PI * 2) + v);
		v -= sqrt ((0.5 - 0.25) / 4.0);
		x = SCREEN_W * (0.25 + v * v * 4);
		textprintf_centre (page, font, x, 60 + y, layout_color (LC_TITLE),
			credits[credits_prev]);
	}
	
	x = SCREEN_W / 2 + credits_scrolling * SCREEN_W / FPS;
	textprintf_centre (page, font,
		x, 60,
		layout_color (LC_TITLE),
		credits[credits_pos]);
}
