/***************************************************************************
 *            ending.cc
 *
 *  Sat Jun 16 20:20:48 2007
 *  Copyright  2007  Darryl LeCount
 *  darryl@jamyskis.net
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <allegro.h>

#ifdef ALLEGRO_LINUX
#include "include/declare.h"
#include "config.h"

#endif

#ifndef ALLEGRO_LINUX
#include "../include/declare.h"
#endif

DUH *endingsong;
AL_DUH_PLAYER *endsongplayer;
extern int music_volume;

using namespace std;

int counter;

bool keyreleased=false;

extern int sfx_volume;

void game_ending()
{
	// Process final score
	
	extern bool game_active;
	extern FONT *gamefont;
	extern int score, lives, hiscore, difficulty;
	extern SAMPLE *newhighscore;
	int textlength;
	int finalscore;
	
	stringstream conversionbuffer[3];
	
	finalscore=score+10000+(lives*1000);
	
	switch(difficulty)
	{
		case 1: finalscore=finalscore+2000; break;
		case 2: finalscore=finalscore+5000; break;
		case 3: finalscore=finalscore+10000; break;
		case 4: finalscore=finalscore+25000; break;
	};
	
	conversionbuffer[0] << "SCORE: " << score;
	conversionbuffer[1] << "BONUS FOR LIVES REMAINING x"<< lives << ": " << lives*1000;
	conversionbuffer[2] << "FINAL SCORE: " << finalscore;
	
	string endinglines[] ={
	"THE WAR IS OVER. THE ALIENS WERE",//0
	"FORCED BACK TO WHENCE THEY CAME.",
	"THE EVIL INVADERS WERE SENT BACK",
	"TO THEIR PUNY HOMEWORLD WITH",
	"THEIR TAILS BETWEEN THEIR LEGS.",
	"",
	"AND THUSLY SPAKE THE PEOPLE OF",
	"EARTH:",
	"\"WE KICKED YO ASSES, MOTHER#""@%$*S!\"",
	"",
	"AT LEAST THEY DID UNTIL",
	"-- OPEN INVADERS II --",
	"",
	"BUT WHAT OF OUR HERO?",
	"",
	"HE'S BACK HOME, BRUSHING UP ON",//15
	"HIS JOYSTICK SKILLS, READY FOR",//16
	"THE INVADERS, LEST THEY DEFY",//17
	"THE HUMAN RACE AGAIN!",//18
	
	conversionbuffer[0].str(),//19
	"",//20
	"COMPLETION BONUS: 10000",//21
	conversionbuffer[1].str(),//22
	conversionbuffer[2].str(),//23
	"THIS IS A NEW HIGH SCORE!", //24
	
	"CREDITS",//25

	"    DESIGN",//26
	"DARRYL LECOUNT",
	
	" PROGRAMMING",//28
	"DARRYL LECOUNT",
	
	"   GRAPHICS",//30
	"DARRYL LECOUNT",
	
	"COLLISION DETECTION CODE",//32
	"         ORZ",
	
	"   TESTING",//34
	" AMBER ADAMS",
	"THE LINUX GUY",
	"LAUREN MAGGS",
	
	"  MUSIC",//38
	"THE MASTER",
	"   JID",
	"  NOISE",
	
	"FONT <\"PRESS START\">",//42
	"  CODY BOISCLAIR",
	
	"FONT <\"ABDUCTION 2002\">",//44
	"    JAKOB FISCHER",
	
	" ALLEGRO LIBRARY", //46
	"SHAWN HARGREAVES",
	
	"            THANKS",//48
	"     #C++ AT IRC.QUAKENET.ORG",
	"ESPECIALLY BD-CALVIN AND SPRUDLING",
	
	"THE CREW AT HAPPYPENGUIN.ORG",//51
	
	"THE GUYS AT ALLEGRO.CC",//52
	
	"    A N D  Y O U",//53
	"                     ",
	"THANK YOU FOR PLAYING",//55
	
	"NO BONUS FOR CHICKEN MODE", //56
	"PLAY IT ON A HARDER LEVEL,",
	"YA CHICKEN!",

	"BONUS FOR EASY MODE: 2000", //59
	"NOW TRY IT ON MEDIUM!",
	"",
	
	"BONUS FOR MEDIUM MODE: 5000", //62
	"NOW TRY IT ON HARD!",
	"",
	
	"BONUS FOR HARD MODE: 10000", //65
	"TRY IT ON INSANE FOR THE",
	"ULTIMATE CHALLENGE!",
	
	"ULTIMATE INSANITY BONUS: 25000", //68
	"CONGRATULATIONS!",
	"YOU ARE AN OPEN INVADERS MASTER!",
	};
	
	// Load and start ending song
	
	endingsong=dumb_load_mod_quick("./data/endsong.mod");
	
	#ifdef ALLEGRO_LINUX
	if(!endingsong)
	{
		endingsong=dumb_load_mod_quick(ENDING_SONG);
	}
	#endif
		
	if(!endingsong)
	{
		cout << "Could not load end song";
		allegro_exit();
		abort();
	}
	
	endsongplayer=al_start_duh(endingsong,2,0,(float) music_volume/10,
		get_config_int("sound", "buffer_size", 4096),
		get_config_int("sound", "sound_freq", 22500));
	
	// Display ending lines
	
	clear(screen);
	
	for(int lines=0; lines<19; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,40,(lines*22)+40,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1700);
	
	clear(screen);	
		
	for(int lines=19; lines<23; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,80,((lines-19)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	int texty=278;
	
	for(int lines=56+(difficulty*3); lines<59+(difficulty*3); lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,80,texty,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
		
		texty=texty+22;
	}
	
	textlength=endinglines[23].length();
	
	for(int individualchars=0; individualchars<textlength+1; individualchars++)
	{
		textprintf_ex(screen,gamefont,80,378,makecol16(255,255,255),0,endinglines[23].substr(0,individualchars).c_str());
		delay_with_duh_poll(20);
	}
	
	if(finalscore>hiscore)
	{
		textlength=endinglines[24].length();
		
		play_sample(newhighscore,sfx_volume,128,1000,0);
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,80,420,makecol16(255,255,255),0,endinglines[24].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
		
		hiscore=finalscore;
		save_hiscore();
	}
	
	delay_with_duh_poll(1700);
	
	clear(screen);
	
	textlength=endinglines[25].length();
	
	for(int individualchars=0; individualchars<textlength+1; individualchars++)
	{
		textprintf_ex(screen,gamefont,340,250,makecol16(255,255,255),0,endinglines[25].substr(0,individualchars).c_str());
		delay_with_duh_poll(20);
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);
	
	for(int lines=26; lines<28; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,80,((lines-19)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);

	clear(screen);
	
	for(int lines=28; lines<30; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,160,((lines-19)*22)+50,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);

	clear(screen);
	
	for(int lines=30; lines<32; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,80,((lines-19)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);
	
	for(int lines=32; lines<34; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,80,((lines-19)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);
	
	for(int lines=34; lines<38; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,230,((lines-23)*22)+10,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);	
	
	for(int lines=38; lines<42; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,400,((lines-25)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);	
	
	for(int lines=42; lines<44; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,400,((lines-25)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);	
	
	for(int lines=44; lines<46; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,350,((lines-35)*22)+120,makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);
	
	for(int lines=46; lines<48; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,40,((lines-36)*22),makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(1200);
	
	clear(screen);
	
	for(int lines=48; lines<51; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,70,((lines-39)*22),makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(2000);
	
	clear(screen);
	
	textlength=endinglines[51].length();
		
	for(int individualchars=0; individualchars<textlength+1; individualchars++)
	{
		textprintf_ex(screen,gamefont,155,200,makecol16(255,255,255),0,endinglines[51].substr(0,individualchars).c_str());
		delay_with_duh_poll(20);
	}
	
	delay_with_duh_poll(2000);

	clear(screen);
	
	textlength=endinglines[52].length();
		
	for(int individualchars=0; individualchars<textlength+1; individualchars++)
	{
		textprintf_ex(screen,gamefont,210,330,makecol16(255,255,255),0,endinglines[52].substr(0,individualchars).c_str());
		delay_with_duh_poll(20);
	}
	
	delay_with_duh_poll(2000);
	
	clear(screen);
	
	for(int lines=53; lines<56; lines++)
	{
		textlength=endinglines[lines].length();
		
		for(int individualchars=0; individualchars<textlength+1; individualchars++)
		{
			textprintf_ex(screen,gamefont,195,((lines-45)*22),makecol16(255,255,255),0,endinglines[lines].substr(0,individualchars).c_str());
			delay_with_duh_poll(20);
		}
	}
	
	delay_with_duh_poll(2000);
	
	for(int volumereduce=music_volume; volumereduce>0; volumereduce--)
	{
		al_duh_set_volume(endsongplayer,(float) volumereduce/10);
		delay_with_duh_poll(100);
	}
	
	al_pause_duh(endsongplayer);
	
	alt_fade_out(screen,1);
		
	remove_int(add_counter);
	game_active=false;
};

void delay_with_duh_poll(int delaylength)
{
	install_int_ex(add_counter,MSEC_TO_TIMER(4));
	
	counter=0;
	
	do {
		al_poll_duh(endsongplayer);
		
		if(input_pressed()&&keyreleased)
		{
			install_int_ex(add_counter,MSEC_TO_TIMER(1));
		}

		if(!input_pressed())
		{
			keyreleased=true;
		}
	}
	while(counter<delaylength);
		
	remove_int(add_counter);	
}

void add_counter()
{
	counter++;	
}

END_OF_FUNCTION(add_counter);

void counter_reset()
{
	counter=0;
}
