/***************************************************************************
 *            init.cc
 *
 *  Fri Jun  1 00:11:12 2007
 *  Copyright  2007  Darryl LeCount
 *  darryl@jamyskis.net
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <allegro.h>

#ifdef ALLEGRO_LINUX
#include "config.h"
#include "include/declare.h"
#endif

#ifndef ALLEGRO_LINUX
#include "../include/declare.h"
#endif

using namespace std;
 
extern int score, lives, posx, wavedirection, level, delay, ufo_delay, projlimit;
extern int next_extra_life, bkoffsetx, bkoffsety, game_condition, hiscore, difficulty;
extern int music_volume;
extern int sfx_volume;
extern bool in_process_of_fading, game_active, program_active, hiscore_beaten;
extern item bulletposition, ufoposition, shipposition;
extern BITMAP *shield_original, *shield_copies[3];
extern BITMAP *logo, *level2bk[2], *level3bk, *level4bk[2], *level5bk, *level6bk;
extern BITMAP *level7bk,*level9bk[3],*level11bk, *level12bk, *level13bk, *level14bk;
extern BITMAP *ship,*projectile,*alien,*death,*ufo;
extern PALETTE gamepalette;
extern FONT *gamefont;
extern SAMPLE *shoot, *explode, *newhighscore, *screenshotsaved, *welcome;
extern SAMPLE *letsgo, *gameisover;
extern DUH *gamesong;
extern startype stars[500], clouds[4], meteors[10], gummis[30];
extern int keysdefined[7];
extern string keynames[7];


void load_data_files()
{
	bool failed=false;
	
	cout << "Loading graphics...\n";
	
	ship=oi_load_graphic("ship.pcx",GFX_SHIP);
	alien=oi_load_graphic("alien.pcx",GFX_ALIEN);
	ufo=oi_load_graphic("ufo.pcx",GFX_UFO);
	projectile=oi_load_graphic("bullet.pcx",GFX_BULLET);
	death=oi_load_graphic("explosion.pcx",GFX_EXPLOSION);
	shield_original=oi_load_graphic("shield.pcx",SHIELD_GRAPHIC);
	logo=oi_load_graphic("oi_logo.pcx",OPEN_INVADERS_LOGO);
	level2bk[0]=oi_load_graphic("level2bk.pcx",LEVEL_TWO_BACKGROUND_LEFT);
	level2bk[1]=oi_load_graphic("level2bk2.pcx",LEVEL_TWO_BACKGROUND_RIGHT);
	level3bk=oi_load_graphic("level3bk.pcx",LEVEL_THREE_BACKGROUND);
	level4bk[0]=oi_load_graphic("level4bk.pcx",LEVEL_FOUR_BACKGROUND_ONE);
	level4bk[1]=oi_load_graphic("level4bk2.pcx",LEVEL_FOUR_BACKGROUND_TWO);
	level5bk=oi_load_graphic("level5bk.pcx",LEVEL_FIVE_BACKGROUND);
	level6bk=oi_load_graphic("level6bk.pcx",LEVEL_SIX_BACKGROUND);
	level7bk=oi_load_graphic("level7bk.pcx",LEVEL_SEVEN_BACKGROUND);
	level9bk[0]=oi_load_graphic("level9bk1.pcx",LEVEL_NINE_BACKGROUND_RED);
	level9bk[1]=oi_load_graphic("level9bk2.pcx",LEVEL_NINE_BACKGROUND_GREEN);
	level9bk[2]=oi_load_graphic("level9bk3.pcx",LEVEL_NINE_BACKGROUND_YELLOW);
	level11bk=oi_load_graphic("level11bk.pcx",LEVEL_ELEVEN_BACKGROUND);
	level12bk=oi_load_graphic("level12bk.pcx",LEVEL_TWELVE_BACKGROUND);
	level13bk=oi_load_graphic("level13bk.pcx",LEVEL_THIRTEEN_BACKGROUND);
	level14bk=oi_load_graphic("level14bk.pcx",LEVEL_FOURTEEN_BACKGROUND);
	
	cout << "Loading sound effects...\n";
	
	shoot=oi_load_sfx("shoot.wav",SHOOT_SOUND);
	explode=oi_load_sfx("destroy.wav",DESTROY_SOUND);
	newhighscore=oi_load_sfx("new_high_score.wav",NEW_HIGH_SCORE_SOUND);
	screenshotsaved=oi_load_sfx("screenshotsaved.wav",SCREENSHOT_SOUND);
	welcome=oi_load_sfx("welcome.wav",WELCOME_SOUND);
	letsgo=oi_load_sfx("letsgo.wav",LETS_GO_SOUND);
	gameisover=oi_load_sfx("gameisover.wav",GAME_IS_OVER_SOUND);
	
	cout << "Loading in-game song...\n";
	gamesong=dumb_load_mod_quick("./data/gamesong.mod");
		
	gamefont=load_bitmap_font("./data/arcade_font.pcx",0,0);
		
	cout << "Loading highscore file...\n";
	load_hiscore();
	
	cout << "Loading config file...\n";
	load_config();
	
	if(!gamefont)
	{
		gamefont=load_bitmap_font(GAME_FONT,0,0);
	}

	if(!gamefont)
	{
		cout << "Fatal error: Could not load file arcade_font.pcx\n";
		failed=true;
	}
	
	if(!gamesong)
	{
		gamesong=dumb_load_mod_quick(GAME_SONG);
	}

	if(!gamesong)
	{
		cout << "Fatal error: Could not load file gamesong.mod\n";
		failed=true;
	}
};

void load_hiscore()
{
	ostringstream filepath;
	int checksum;
	
	#ifndef ALLEGRO_LINUX
	filepath << "./data/hiscore.dat";
	#else
	filepath << getenv("HOME") << "/.openinvaders/hiscore";
	#endif
	
	ifstream hiscorefile;
	char teststring[5];
	bool valid_file=true;
	bool skip_checksum=false;
	
	hiscorefile.open(filepath.str().c_str(),ios::binary);
	
	hiscorefile.read(teststring,4);
	
	if(!memcmp(teststring,"V002",4)==0&&hiscorefile.is_open())
	{
		clear(screen);
		textout_ex(screen, gamefont, "PLEASE NOTE", 30,30,-1,-1);
		textout_ex(screen, gamefont, "Open Invaders has detected that you", 30,80,-1,-1);
		textout_ex(screen, gamefont, "have an invalid highscore file. Since", 30,110,-1,-1);		
		textout_ex(screen, gamefont, "version 0.02 the game saves hiscores", 30,140,-1,-1);
		textout_ex(screen, gamefont, "and data in binary format. This ", 30,170,-1,-1);
		textout_ex(screen, gamefont, "means that existing highscores are", 30,200,-1,-1);
		textout_ex(screen, gamefont, "lost. Sorry.",30,230,-1,-1);
		textout_ex(screen, gamefont, "PRESS ANY KEY TO CONTINUE", 30,280,-1,-1);
		
		do {}
		while(!keypressed());
		valid_file=false;
		skip_checksum=true;
	}
	
	clear_keybuf();
	
	hiscorefile.read(reinterpret_cast<char*>(&hiscore),sizeof(hiscore));
	hiscorefile.read(reinterpret_cast<char*>(&checksum),sizeof(checksum));
	
	if(checksum!=(hiscore*239)-686&&!skip_checksum&&hiscorefile.is_open())
	{
		clear(screen);
		textout_ex(screen, gamefont, "NAUGHTY, NAUGHTY!", 30,30,-1,-1);
		textout_ex(screen, gamefont, "It looks like you've been trying to", 30,80,-1,-1);
		textout_ex(screen, gamefont, "cheat by changing your highscore", 30,110,-1,-1);		
		textout_ex(screen, gamefont, "file. You obviously didn't know", 30,140,-1,-1);
		textout_ex(screen, gamefont, "about the security measures in place", 30,170,-1,-1);
		textout_ex(screen, gamefont, "to stop cheating gits like you doing", 30,200,-1,-1);
		textout_ex(screen, gamefont, "that. DON'T DO IT.",30,230,-1,-1);
		textout_ex(screen, gamefont, "PRESS ANY KEY TO CONTINUE", 30,280,-1,-1);
		
		do {}
		while(!keypressed());
		valid_file=false;
	}
	
	if(!valid_file)
	{
		hiscore=0;
	}
	
	hiscorefile.close();
}

void save_hiscore()
{		
	ostringstream filepath;
	int checksum = (hiscore*239)-686; //simple, I know!
	
	#ifndef ALLEGRO_LINUX
	filepath << "./data/hiscore.dat";
	#else
	filepath << getenv("HOME") << "/.openinvaders";
	mkdir(filepath.str().c_str(),S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);
	filepath << "/hiscore";	
	#endif
	
	ofstream hiscorefile;
	hiscorefile.open(filepath.str().c_str(),ios::binary);
	
	hiscorefile.write("V002",4);
	hiscorefile.write(reinterpret_cast<char*>(&hiscore),sizeof(hiscore));
	hiscorefile.write(reinterpret_cast<char*>(&checksum),sizeof(checksum));
}

void load_config()
{
	ostringstream filepath;
	
	#ifndef ALLEGRO_LINUX
	filepath << "./data/config.dat";
	#else
	filepath << getenv("HOME") << "/.openinvaders";
	mkdir(filepath.str().c_str(),S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);
	filepath << "/config";	
	#endif
	
	ifstream configfile;
	string string_to_compare;
	string parameter,value;
	int position_of_equals;
	int length_of_value;
	bool success_check; 
	bool verified=false;
	configfile.open(filepath.str().c_str(),ios::binary);
	
	do
	{
		success_check=configfile >> string_to_compare;
		if(success_check)
		{
			position_of_equals=string_to_compare.find("=");
			if(position_of_equals>-1)
			{
				parameter=string_to_compare.substr(0,position_of_equals);
				length_of_value=string_to_compare.length()-position_of_equals;
				value=string_to_compare.substr(position_of_equals+1,length_of_value);
				if(parameter=="version"&&value=="0.02")
				{
					verified=true;
				}
				
				if(parameter=="difficulty")
				{
					difficulty=atoi(value.c_str());
					if(difficulty<0||difficulty>4)
					{
						difficulty=2;
					}
				}
				
				if(parameter=="vol_music")
				{
					music_volume=atoi(value.c_str());
					if(music_volume<0||music_volume>10)
					{
						music_volume=7;
					}
				}
				
				if(parameter=="vol_sfx")
				{
					sfx_volume=atoi(value.c_str());
					if(sfx_volume<0||sfx_volume>250)
					{
						sfx_volume=250;
					}
				}
				
				if(parameter=="keyboard_LEFT")
				{
					keysdefined[0]=atoi(value.c_str());
					if(keysdefined[0]<1||keysdefined[0]>=KEY_MAX)
					{
						keysdefined[0]=KEY_LEFT;
					}
				}					
				
				if(parameter=="keyboard_RIGHT")
				{
					keysdefined[1]=atoi(value.c_str());
					if(keysdefined[1]<1||keysdefined[1]>=KEY_MAX)
					{
						keysdefined[1]=KEY_RIGHT;
					}
				}
				
				if(parameter=="keyboard_UP")
				{
					keysdefined[2]=atoi(value.c_str());
					if(keysdefined[2]<1||keysdefined[2]>=KEY_MAX)
					{
						keysdefined[2]=KEY_UP;
					}
				}
				
				if(parameter=="keyboard_DOWN")
				{
					keysdefined[3]=atoi(value.c_str());
					if(keysdefined[3]<1||keysdefined[3]>=KEY_MAX)
					{
						keysdefined[3]=KEY_DOWN;
					}
				}
				
				if(parameter=="keyboard_FIRE")
				{
					keysdefined[4]=atoi(value.c_str());
					if(keysdefined[4]<1||keysdefined[4]>=KEY_MAX)
					{
						keysdefined[4]=KEY_LSHIFT;
					}
				}
				
				if(parameter=="keyboard_PAUSE")
				{
					keysdefined[5]=atoi(value.c_str());
					if(keysdefined[5]<1||keysdefined[5]>=KEY_MAX)
					{
						keysdefined[5]=KEY_P;
					}
				}
				
				if(parameter=="keyboard_QUIT")
				{
					keysdefined[6]=atoi(value.c_str());
					if(keysdefined[6]<1||keysdefined[6]>=KEY_MAX)
					{
						keysdefined[6]=KEY_Q;
					}
				}

			}
		}			
	}
	while(success_check);
		
	configfile.close();
}

void save_config()
{
	ostringstream filepath;
	
	#ifndef ALLEGRO_LINUX
	filepath << "./data/config.dat";
	#else
	filepath << getenv("HOME") << "/.openinvaders";
	mkdir(filepath.str().c_str(),S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);
	filepath << "/config";	
	#endif
	
	ofstream configfile;
	configfile.open(filepath.str().c_str(),ios::binary);
	
	configfile << "version=0.2\n";
	configfile << "difficulty=" << difficulty << "\n";
	configfile << "vol_music=" << music_volume << "\n";
	configfile << "vol_sfx=" << sfx_volume << "\n";
	
	for(int a=0; a<7; a++)
	{
		configfile << "keyboard_" << keynames[a] << "=" << keysdefined[a] << "\n";
	}
	
	configfile.close();
}
	  
int convert_charstring_to_int(const char* string_to_convert)
{
	char single_character;
	double return_value;
	double value_to_add;
	double power;
	const int length_of_string = strlen(string_to_convert);	

	return_value=0;

	for(int eachchar=0; eachchar<length_of_string; eachchar++)
	{
		single_character = string_to_convert[eachchar];
		value_to_add = (int) single_character-'0';	

		if(value_to_add<0||value_to_add>9)
		{
			return -1;
		}

		power = (length_of_string-1)-eachchar;
		value_to_add = value_to_add * pow(10,power);
		return_value=return_value+value_to_add;
	}

	return (int) return_value;
}


void initialise_game()
{
	allegro_init();
	atexit(&dumb_exit);
	dumb_register_stdfiles();
	install_timer();
	install_keyboard();
	install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL);
	install_joystick(JOY_TYPE_AUTODETECT);
	install_pmask();
	calibrate_joystick(0);
	install_int(interrupt_keys,60); // This routine checks for CTRL+C or CTRL+S
	difficulty=2;
	music_volume=7;
	sfx_volume=250;
	
};

void predefine_variables()
{
	srand(unsigned(time(0)));
	
	score=0;
	lives=3;
	posx=20;
	hiscore_beaten=false;
	wavedirection=1;
	level=1;
	bulletposition.alive=dead;
	delay=0;
	ufo_delay=0;
	ufoposition.alive=dead;
	ufoposition.xpos=0;
	ufoposition.ypos=40;
	projlimit=4;
	next_extra_life=20000;
	bkoffsetx=0;
	bkoffsety=0;
	in_process_of_fading=false;
	game_condition=0;
	
	game_active=true;
	
	shipposition.alive=alive;
	
	reset_shields();
	
	for(int starcount=0; starcount<500; starcount++)
	{
		stars[starcount].x=rand()%SCREEN_W;
		stars[starcount].y=rand()%SCREEN_H;
		stars[starcount].speed=(rand()%4)+1;
	};
	
	for(int cloudcount=0; cloudcount<4; cloudcount++)
	{
		clouds[cloudcount].x=rand()%SCREEN_W;
		clouds[cloudcount].y=rand()%400;
		clouds[cloudcount].speed=(rand()%3)+1;
		clouds[cloudcount].color=rand()%2;
	}
	
	for(int meteorcount=0; meteorcount<10; meteorcount++)
	{
		meteors[meteorcount].x=rand()%SCREEN_W;
		meteors[meteorcount].y=rand()%SCREEN_H;
		meteors[meteorcount].speed=(rand()%7)+3;
	}
	
	for(int gummicount=0; gummicount<30; gummicount++)
	{
		gummis[gummicount].x=rand()%SCREEN_W;
		gummis[gummicount].y=rand()%SCREEN_H;
		gummis[gummicount].speed=(rand()%4)+2;
	}
};

void reset_shields()
{	
	for(int copies=0; copies<3; copies++)
	{
		blit(shield_original,shield_copies[copies],0,0,0,0,140,88);
	};
}

BITMAP *oi_load_graphic(std::string filename, std::string defsymbol)
{
	BITMAP *loaded_graphic;
	ostringstream filenamebuffer;
	
	filenamebuffer << "./data/" << filename;
	
	loaded_graphic=load_bitmap(filenamebuffer.str().c_str(),NULL);

#ifdef ALLEGRO_LINUX	
	if(!loaded_graphic)
	{
		loaded_graphic=load_bitmap(defsymbol.c_str(), NULL);
	}
#endif	
	
	if(!loaded_graphic)
	{
		cout << "Fatal error: Could not load file " << filename << "\n";
		return false;
	}

	return loaded_graphic;
}


SAMPLE *oi_load_sfx(std::string filename, std::string defsymbol)
{
	SAMPLE *loaded_sound;
	ostringstream filenamebuffer;
	
	filenamebuffer << "./data/" << filename;
	
	loaded_sound=load_wav(filenamebuffer.str().c_str());

#ifdef ALLEGRO_LINUX	
	if(!loaded_sound)
	{
		loaded_sound=load_wav(defsymbol.c_str());
	}
#endif	

	if(!loaded_sound)
	{
		cout << "Fatal error: Could not load file " << filename << "\n";
		return false;
	}
	
	return loaded_sound;
}
