/**\file n_str.c
*
*  string function
*
*  Everything you need to use string is here
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 01/04/05
*
*\warning If there is one, read the warning of the function
*/



#include "nilorea.h"



#ifndef NOSTR



/*!\fn Strcpy( char *from , char *to , int nboct )
 *
 *\brief brut copy of string, to get all data stored after the end of string ( ==0 )
 *
 *\param from a char *string input
 *\param to a char *string output
 *\param nboct an int who's size is the number of octet to be copyied from source
 *
 *\warning do not use a "nboct" value bigger than the size of 'from' or 'to'
 *
 *\return TRUE on success , FALSE on error
 */

int Strcpy( char *from , char *to , int nboct )
    {

    int it; /*iterator*/

    if ( !from ) {
            fprintf( stderr ,
                     "Strcpy: Param (char *from) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    if ( !to ) {
            fprintf( stderr ,
                     "Strcpy: Param (char *to) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    for ( it = 0 ; it < nboct ; it ++ )  /*brut copy*/
        to[ it ] = from[ it ];

    return TRUE;

    } /*Strcpy*/



/*!\fn Strncpy( char *from , char *to , int start , int end ,char skip)
 *
 *\brief  A strcpy from[start to end] to[0 to (end-start)]
 *
 *\param from a char *string source
 *\param to a char *string dest
 *\param start an int starting index on from
 *\param end an int ending index on from
 *\param skip a char character to skip while copying (fill by -1 if no skip needed)
 *
 *\warning be shure that 'to' is enought big to receive from[start to end]
 *
 *\return TRUE on success , FALSE on error
 */

int Strncpy( char *from , char *to , int start , int end , char skip )
    {

    int it, it1;

    /* Error checking */

    if ( !from ) {
            fprintf( stderr ,
                     "Strcpy: Param (char *from) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }


    if ( !to ) {
            fprintf( stderr ,
                     "Strcpy: Param (char *to) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }


    /*always got start < end*/
    if ( start > end ) {
            it = start ;
            start = end ;
            end = it ;
            }

    it1 = 0;

    for ( it = start ; it <= end ; it ++ ) {

            if ( skip == -1 ) {

                    to[ it1 ] = from[ it ] ;
                    it1 = it1 + 1;
                    }

            else {

                    if ( from[ it ] != skip ) {

                            to[ it1 ] = from[ it ] ;
                            it1 = it1 + 1;
                            }
                    }
            }

    return TRUE;

    } /* Strncpy(...)*/



/*!\fn fill_str( char *string , char value , int length )
 *
 *\brief fill a string by value from 0 to length
 *
 *\param string a char *string to fill
 *\param value a char value for filling string
 *\param length an int for the length of the string
 *
 *\warning be shure string isn't fewer than length
 *
 *\return TRUE on success FALSE on error
 */

int fill_str( char *string, char value, int length )
    {

    int it;

    if ( !string ) {
            fprintf( stderr ,
                     "fill_str: Param (char *string) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    for ( it = 0 ; it < length ; it ++ )
        string[ it ] = value;

    return TRUE;

    } /*fill_str(...)*/



/*!\fn Skipw( char *string , char toskip , int *iterator , int inc )
 *
 *\brief skip while 'toskip' occurence is found from 'iterator' to the next non 'toskip' position.
 * The new iterator index is automatically stored, returning to it first value if an error append.
 *
 *\param string a char *string to search in
 *\param toskip skipping while char character 'toskip' is found
 *\param iterator an int iteraor position on the string
 *\param inc an int to specify the step of skipping
 *
 *\return TRUE if success FALSE if error
 */

int Skipw( char *string , char toskip , int *iterator , int inc )
    {

    int previous;

    if ( !string ) {

            fprintf( stderr ,
                     "Skipw: Param (char *string) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    previous = *iterator;

    if ( toskip == ' ' ) {

            while ( *iterator >= 0 && *iterator <= (signed)strlen ( string ) &&
                    ( string[ *iterator ] == toskip || string[ *iterator ] == '\t' ) )
                * iterator = *iterator + inc;

            }

    else {

            while ( *iterator >= 0 && *iterator <= (signed)strlen ( string ) && string[ *iterator ] == toskip )
                * iterator = *iterator + inc;

            }

    if ( *iterator > (signed)strlen ( string ) || *iterator < 0 ) {
            *iterator = previous ;
            return FALSE;
            }

    return TRUE;

    } /*Skipw(...)*/



/*!\fn Skipu( char *string , char toskip , int *iterator , int inc )
 *
 *\brief skip until 'toskip' occurence is found from 'iterator' to the next 'toskip' value.
 * The new iterator index is automatically stored, returning to it first value if an error append.
 *
 *\param string a char *string to search in
 *\param toskip skipping while char character 'toskip' isnt found
 *\param iterator an int iteraor position on the string
 *\param inc an int to specify the step of skipping
 *
 *\return TRUE if success FALSE if error
 */

int Skipu( char *string , char toskip , int *iterator , int inc )
    {

    int previous;

    if ( !string ) {

            fprintf( stderr ,
                     "Skipu: Param (char *string) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    previous = *iterator;

    if ( toskip == ' ' ) {

            while ( *iterator >= 0 && *iterator <= (signed)strlen ( string ) &&
                    string[ *iterator ] != toskip && string[ *iterator ] != '\t' )
                * iterator = *iterator + inc;

            }

    else {

            while ( *iterator >= 0 && *iterator <= (signed)strlen ( string ) && string[ *iterator ] != toskip )
                * iterator = *iterator + inc;

            }

    if ( *iterator > (signed)strlen ( string ) || *iterator < 0 ) {
            *iterator = previous ;
            return FALSE;
            }

    return TRUE;

    } /*Skipu(...)*/



/*!\fn strup( char *string , char *dest )
 *
 *\brief Upper case a string
 *
 *\param string the string to change to upper case
 *\param dest the string where storing result
 *
 *\warning string must be same size as dest
 *
 *\return TRUE or FALSE
 */

int strup( char *string , char *dest )
    {

    int it;

    if ( !string ) {

            fprintf( stderr ,
                     "strup: Param (char *string) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    if ( !dest ) {

            fprintf( stderr ,
                     "strup: Param (char *dest) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }


    for ( it = 0 ; it < (signed)strlen( string ) ; it++ )
        dest[ it ] = toupper ( string[ it ] );

    return TRUE;

    } /*strup(...)*/



/*!\fn strlo( char *string , char *dest )
 *
 *\brief Upper case a string
 *
 *\param string the string to change to lower case
 *\param dest the string where storing result
 *
 *\warning string must be same size as dest
 *
 *\return TRUE or FALSE
 */

int strlo( char *string , char *dest )
    {

    int it;


    if ( !string ) {

            fprintf( stderr ,
                     "strlo: Param (char *string) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }

    if ( !dest ) {

            fprintf( stderr ,
                     "strlo: Param (char *dest) = NULL at line %d of %s\n" ,
                     __LINE__ , __FILE__ );
            return FALSE;
            }


    for ( it = 0 ; it < (signed)strlen( string ) ; it++ )
        dest[ it ] = tolower ( string[ it ] );

    return TRUE;

    } /*strlo(...)*/



#endif /* #ifndef NOSTR */
