/**\file iso_anim.h
*
*  2D animations for Iso Engine
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 19/07/05
*
*/



#ifndef __2D_ANIM__
 #define __2D_ANIM__


/*!
 * type of a normal blitted sprite
 */

#define NORMAL_SPRITE 0



/*!
 * type of a masked sprite
 */

#define MASKED_SPRITE 1



/*!
 * type of a Transp sprite
 */

#define TRANS_SPRITE 2



/*! Struct of a cell of an animation */

typedef struct SPRITE
        {

        /*! sprite */
        BITMAP **spr;

        int /*! w size */
        w,
        /*! h size */
        h,
        /*! x center of sprite */
        x,
        /*! y center of sprite */
        y,
        /*! id of the sprite -1 for unavailable */
        id,
        /*! type of data ( blend , mask , normal ) */
        type,
        /*! is animated ? true or false */
        animated,
        /*! delays between image -1 if no (in msec) */
        delay,
        /*! number of pictures in **spr */
        current,
        /*! max picture in **spr */
        max,
        /*! namelenght */
        namelenght,
        /*! status of the sprite, TRUE or FALSE */
        alive;

        /*! handles to opengl textures if enable (not saved or loaded) */
        GLuint *handles;

        /*! name of sprite */
        char *name;

        }

SPRITE;



/*! Struct of a library of animations */

typedef struct ANIM
        {

        /*! array of sprites */
        SPRITE **data;


        int
        /*! number of sprites in lib */
        nbsprite,
        /*! position-id of the hightest sprite in lib */
        hightest,
        /*! nb max sprites */
        max,
        /*! size of name */
        namelenght;

        /*! name of the library, null if no */
        char *name;

        }

ANIM;



/*******************************************************************************
                              SPRITE ROUTINES
*******************************************************************************/


/*
 * init a SPRITE
 */

int init_sprite( SPRITE **spr , char *name ,
                 int w , int h ,
                 int x , int y ,
                 int id ,
                 int type ,
                 int animated ,
                 int delay ,
                 int max );


/*
 * Add if possible a bimtap to a sprite
 */

int add_bmp_to_spr( BITMAP *bmp , SPRITE *spr );



/*
 * read a sprite in an opening file
 */

int read_sprite_in_file( PACKFILE *file , SPRITE **spr );



/*
 * write a sprite in an opening file
 */

int write_sprite_in_file( PACKFILE *file , SPRITE *spr );


/*
 * draw a sprite at the right position
 */

int blit_sprite( SPRITE *sprite , int x , int y , int frame , BITMAP *bmp );



/*
 * free a sprite from memory
 */

int free_sprite( SPRITE **spr );



/*******************************************************************************
                             ANIMATION ROUTINES
*******************************************************************************/



/*
 * Create an empty libray of anims
 */

int create_animlib( ANIM **lib , char *name , int max );


/*
 * load an anim file from disk , return FALSE if : not existing and
 * error creating : existing and error reallocating if not enought big)
 */

int load_animlib( PACKFILE *file , ANIM **lib );



/*
 * save an anim library to disk ( cropping the various arrays )
 */

int save_animlib( PACKFILE *file , ANIM *lib );



/*
 * add sprite to lib
 */

int add_sprite_to_lib( SPRITE *spr , ANIM *lib );


/*
 * remove sprite from library
 */

int remove_sprite_from_lib( ANIM *lib , int id );

/*
 * Resize a library for nbelement
 */

int Resize_anim_lib( ANIM *lib , int nb );



/*
 * free an anim library
 */

int free_anim( ANIM *lib );


/*
 * draw a sprite in lib
 */

int blit_anim( ANIM *lib , int id , int x , int y , int frame , BITMAP *bmp );



/*
 * check if a sprite already exist in a lib
 */

int exist_sprite( ANIM *lib , char *name );




#endif /*#ifndef __2D_ANIM__*/

