/**\file common.h
*
*  common headers and low-level hugly functions & define
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 24/03/05
*
*/



#ifndef __COMMON_FOR_C_IMPLEMENTATION__
 #define __COMMON_FOR_C_IMPLEMENTATION__



/*!
 * feature test macro
 */

#define __EXTENSIONS__



/* common headers */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <ctype.h>
#include <malloc.h>
#include <math.h>
#include <time.h>



/* cross compability */

#ifdef LINUX

/* For the gettimeofday function */
#include <sys/time.h>

#ifndef NOALLEGRO

#include <allegro.h>
 #include <linalleg.h>
#include <agup.h>

FONT *allegro_font;

#endif /* #ifndef NOALLEGRO */

#ifndef NONETWORK

#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/socket.h>

#ifndef SOCKET
 #define SOCKET int
#endif


/*!
 * Netflag for sigpipe
 */

#define NETFLAGS MSG_DONTWAIT /* for program to not quit under linux when a connection is crashing 2 times */

#endif /* #ifndef NONETWORK */


#else  /* if we are on a microsoft system */

#include "time.h"

#ifndef NOALLEGRO

#include <allegro.h>
 #include <winalleg.h>

FONT *allegro_font;

#else

#include <windows.h>

#endif /*#ifndef NOALLEGRO*/

#ifndef NONETWORK

#include <winsock.h>
 #include <winsock2.h>

/*!
* Netflag for sigpipe
*/

#define NETFLAGS 0           /* no flags needed for microsoft */

#endif /* #ifndef NONETWORK */

#endif /* #ifdef LINUX */



/*
 * for the 'press a key to continue'
 */

void PAUSE();



/*!
 * On some platform some stupid forgot to define TRUE
 */

#ifndef TRUE
 #define TRUE  -1
#endif

#ifndef true
 #define true  -1
#endif



/*!
 *  On some platform some stupid forgot to define FALSE
 */

#ifndef FALSE
 #define FALSE 0
#endif

#ifndef false
 #define false 0
#endif



/*!
 * bool type
 */

typedef int BOOL;



/*!
 *  returned by N_STRLIST functions to tell the caller that the list is empty
 */

#ifndef EMPTY
 #define EMPTY 2
#endif



/*!
 *  Malloc Handler to get errors
 */

#define Malloc(__ptr,__struct,__size)                                                                                                  \
  if ( !(  __ptr  = (  __struct  *) malloc(  __size  * sizeof(  __struct  ) ) ) ){                                                     \
  fprintf( stderr ,"( %s *)malloc( %s * sizeof( %d ) ) Error at line %d of %s \n", #__ptr , #__struct , __size , __LINE__ , __FILE__); \
  __ptr = NULL;\
  }



/*!

*  Free handler
*/

#define Free( __ptr ) \
  if (  __ptr  ) {    \
    free(  __ptr  );  \
     __ptr  = NULL;   \
               }



/*
 * typedefine for unsigned category for basic native types
 */



/*! shortcut for unsigned int*/
typedef unsigned int uint;

/*! shortcut for unsigned long*/
typedef unsigned long ulong;

/*! shortcut for unsigned short*/
typedef unsigned short ushort;

/*! shortcut for unsigned char*/
typedef unsigned char uchar;



/*!
 * Flag for SET something , passing as a function parameters
 */

#define SET 1234



/*!
 * Flag for GET something , passing as a function parameters
 */

#define GET 4321



/*!
 * Initialize the random sequence with time
 */

#define randomize() { srand((unsigned)time(NULL)); rand(); }



/*!
 * Timing Structure
 */


typedef struct N_TIME
        {

time_t delta;

#ifndef LINUX
        LARGE_INTEGER freq;
        LARGE_INTEGER startTime;
        LARGE_INTEGER currentTime;

#else

        timeval startTime;
        timeval currentTime;

#endif

        }

N_TIME;



/*
 * Init or restart from zero any N_TIME HiTimer
 */

void start_HiTimer( N_TIME *timer );



/*
 * Poll any N_TIME HiTimer, returning usec
 */

time_t get_usec( N_TIME *timer );



/*
 * Poll any N_TIME HiTimer, returning usec
 */

time_t get_msec( N_TIME *timer );



/*
 * Poll any N_TIME HiTimer, returning usec
 */


time_t get_sec( N_TIME *timer );



/* nothing good can be created without posix thread ;-) */

#ifndef NOPTHREAD



#include <pthread.h>


/*!
 * Default APP_STATUS Value
 */

#define DEFAULT    1000


/*!
 * Value of the state of an application who is running
 */

#define RUNNING    1001



/*!
 * Value of the state of an application who want to stop his activity
 */

#define STOPWANTED 1002



/*!
 * Value of the state of an application who is stopped
 */

#define STOPPED    1003



/*!
 * Value of the state of an application who is paused
 */

#define PAUSED     1004



/*!
 * Process monitoring structure
 */

typedef struct PROCESS
        {

        /*! Current status of an application */
        int APP_STATUS ;
        /*! Mutex for APP_STATUS */
        pthread_mutex_t APP_STATUS_MUTEX;

        }

PROCESS;



/*
 * Return the current status of an application
 */

int GetAppStatus( PROCESS *proc );



/*
 * Set the status of an application
 */

int SetAppStatus( PROCESS *proc , int status );



/*!
 * ThreadSafe LOGging structure
 */

typedef struct TS_LOG{

    /*! mutex for thread-safe writting */
    pthread_mutex_t LOG_MUTEX;
    /*! File handler */
    FILE *file;

}TS_LOG;



/*
 * Open a thread-safe logging file
 */

int open_safe_logging( TS_LOG *log , char *pathname , char *opt );



/*
 * write to a thread-safe logging file
 */

int write_safe_log( TS_LOG *log , char *pat , ... );



/*
 * close a thread-safe logging file
 */

int close_safe_logging( TS_LOG *log );



#endif /* #ifndef NOPTHREAD */



#ifndef NOALLEGRO

/*
 * Fill a keyboard buffer
 */

void get_keyboard( char *keybuf , int *cur , int max );

#endif /* #ifndef NOALLEGRO */



#endif /* #ifndef __COMMON_FOR_C_IMPLEMENTATION__ */
