/**\file nilorea.h
*
*  Header to include for use with libnilorea
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 24/03/05
*/



#ifndef __NILOREA_Unified_Library__
#define __NILOREA_Unified_Library__



/* #define LINUX */



/* #define NOALLEGRO   */
/* #define NOSOUND     */
/* #define NOPTHREAD   */
/* #define NONETWORK   */
/* #define NOISOENGINE */
/* #define NOSTR       */
/* #define NETW_DEBUG  */

/* #define DEBUGMODE */



#define _N_ENGINE_VER_ "1.0 b"



/*common C including: socket, thread, ...
  ( i like C, it is sooo ... hugly, isn't it ;-P ) */

#include "common.h"



/* Nilorea Library API */



#ifndef NOSTR

/*header for string routine*/
#include "n_str.h"

/*header for string doubly linked list*/
#include "n_strlist.h"

#endif /*#ifndef NOSTR*/



#ifndef NONETWORK

#ifdef NOSTR
 #error You must use N_STR parts for network engine
 #endif

/*header for network*/
#include "network.h"

#endif /*#ifndef NONETWORK*/



#ifndef NOISOENGINE

#ifdef NOSOUND
 #error You must use sound's for map look like some real ones
 #endif

#ifdef NOALLEGRO
 #error You must include allegro part for using iso engine
 #endif

/* gfx mode */
#include <alleggl.h>

#include "n_grafic.h"

/* iso engine */
#include "iso_anim.h"

#include "n_sound.h"

#include "iso_engine.h"



#endif /*#ifndef NOISOENGINE*/



#endif /*#ifndef __NILOREA_Unified_Library__*/
