/**\file network.h
*
*  network declaration
*
*  Network Engine
*
*\author Castagnier Mickal
*
*\version 1.0
*
*\date 10/05/2005
*
*/


#ifndef N_NETWORK
#define N_NETWORK



/*!
 * a CLIENT (meaning connecting)
 */

#define CLIENT 111



/*!
 * a SERVER (meaning listening)
 */

#define SERVER 222


/*!
 *Structure of a N_SOCKET
 */

typedef struct N_SOCKET
        {

        /*!port of socket*/
        int port;

        /*!a normal socket*/
        SOCKET sock;

        /*!ip of the connected socket*/
        char *ip;

        /*!address of local machine*/

        struct sockaddr_in laddr;
        /*!address of remote machine*/

        struct sockaddr_in haddr;


        }

N_SOCKET;



/*!
 *Structure of a NETWORK
 */

typedef struct NETWORK
        {

        /*!Nb pending connection,if listening*/
        int nb_pending,
        /*!NETWORK mode , 1 listening, 0 connecting*/
        mode,
        /*!Nb octet sended*/
        sended,
        /*!Nb octet recved*/
        recved;

        /*! start time */
        N_TIME start,
        /*! time elapsed since last check*/
        loop_time;


        /*!networking socket*/
        N_SOCKET link;

        /*!sending buffer (for outgoing queuing )*/
        N_STRLIST *send_buf;

        /*!reveicing buffer (for incomming usage)*/
        N_STRLIST *recv_buf;

        /*!mutex for threaded use of Do_..._Networking*/
        pthread_mutex_t sendbolt;
        /*!mutex for threaded use of Do_..._Networking*/
        pthread_mutex_t recvbolt;


        }

NETWORK;



/*
 * Used by Init & Close network
 */

int Handle_Wsa( int mode , int v1 , int v2 );



/*
 * Initialize network, do nothing under linux
 */

int Init_All_Network( int version1 , int version2 );



/*
 * Close network, do nothing under linux
 */

int Close_All_Network();



/*
 * Connecting
 */

int Connect_Network( NETWORK **netw , char *ip , int port );



/*
 * Closing
 */

int Close_Network( NETWORK *netw );



/*
 * Listening network
 */

int Make_Listening_Network( NETWORK **netw , int PORT , int nbpending );



/*
 * Accepting routine
 */

NETWORK *Accept_From_Network( NETWORK *from );


/*
 * Add a message to send in aimed NETWORK
 */

int Add_Msg( NETWORK *netw , char *msg , int nboct );



/*
 * Get a message from aimed NETWORK
 */

int Get_Msg( NETWORK *netw , char **msg , int *nboct );



/*
 * Manage a NETWORK who have made the Connect
 */

int Do_Connecting_Network( NETWORK *netw );



/*
 * Manage a NETWORK who have made the Accept
 */

int Do_Accepting_Network( NETWORK *netw );



/*
 * Writting to a socket
 */
int send_data( SOCKET s,   /* connected socket */
               char *buf,  /* pointer to the buffer */
               int n      /* number of characters (bytes) we want */
             );



/*
 * Reading from a socket
 */
int recv_data( SOCKET s,   /* connected socket */
               char *buf,  /* pointer to the buffer */
               int n );



/*
 * Load the server config file, create it on error
 */

int load_server_config( char *file ,
                        int *MAX_CLIENTS , int *RESERVED , int *PORT ,
                        int *ADMPORT , int *LOGGING , int *sendlimit ,
                        int *recvlimit );



/*
 * Load the server config file, create it on error
 */

int save_server_config( char *file ,
                        int MAX_CLIENTS , int RESERVED , int PORT ,
                        int ADMPORT , int LOGGING ,
                        int sendlimit , int recvlimit );



/*
 * Load the client config file, create it on error
 */

int load_client_config( char *file ,
                        char **ip , int *PORT , int *LOGGING );


/*
 * Load the client config file, create it on error
 */

int save_client_config( char *file ,
                        char *ip , int PORT , int LOGGING );


#endif /*#ifndef N_NETWORK*/

