/* 
   Name: EndFunctions.h
   Author: Castagnier Mickal
   Description: Contient les descriptions des fonctions
   Date:  19/11/03
   Copyright: Nilorea.com

*/

/*******************************************************************************
*****Fichier contenant les include des descriptions de fonctions****************
*******************************************************************************/
/*!\fn init_HiTimer( N_TIME *timer )
 *
 *\brief Initialize any N_TIME HiTimer
 *
 *\return TRUE
 */

int init_HiTimer( N_TIME *timer ) {

    /* querying frequency */
    QueryPerformanceFrequency( ( LARGE_INTEGER * ) &( timer -> freq ) );
    /* convertion */
    timer ->freqd = (double) timer -> freq;
    /* querying QPC */
    QueryPerformanceCounter( &timer -> ts );
    /* set starting time */
    timer ->tts = timer -> ts . QuadPart;
    /* initialize t zero */
    timer ->timer = 0;

    return TRUE;

}/* init_HiTimer(...) */



/*!\fn get_HiTimer( N_TIME *timer )
 *
 *\brief Get the delta time ofthe given timer
 *
 *\param timer a N_TIME timer to process
 *
 *\return The delta time since the last call to himslef or init_HiTimer
 */

float get_HiTimer( N_TIME *timer ){

       /* get performance counter */
       QueryPerformanceCounter( &timer -> te );
       /* set the end time */
       timer -> tte   = timer -> te . QuadPart ;
       /* get the delta time */
       timer -> timer = (float)( (double)( timer -> tte - timer -> tts ) / timer -> freqd ) ;
       /* set the end as start */
       timer -> tts   = timer -> tte;

       return timer -> timer;

}/* get_HiTimer(...) */


#include "2disoend.h"    //description des fonction de type MAP & TILE
#include "gfxlibend.h"      //description des fonction de type TILE
#include "EndObject.h"   //description des fonction de type Objet
#include "endnetworking.h" //fonction de reseau
#include "EndUser.h"     //description des fonction de type User
#include "EndGrafics.h"  //description des fonctions grafiques


