#define RES_X							800
#define RES_Y							600
#define HALF_RES_X					400
#define HALF_RES_Y					300
#define LIGHTNESS						50
#define DEPTH							1.5
#define FRICTION						0.9

#define MAX_LAME						30
#define CHICKEN_SPEED				1
#define CHICKEN_ROCKET				-7
#define ROUND_SECONDS				120
#define LAME_SCORE_FACTOR			4
#define LAME_SPEED_FACTOR			0.5

#define LAME_POINT					(HALF_RES_Y + 200)
#define COW_POINT						100

#define LAME_SIZE_X					80
#define LAME_SIZE_Y					28
#define LAME_HIT_SPEED				15

#define COW_SIZE_X					148
#define COW_SIZE_Y					138
#define COW_PARTS						10
#define COW_CHANCE					5000
#define COW_SPEED						-3
#define COW_WORTH						20
#define TIME_PIECES					100

#define LAME_STATE_NORMAL			0
#define LAME_STATE_FLYING_UP		1
#define LAME_STATE_FLYING_DOWN	2

#define CHICKEN_STATE_UNLAUNCH	0
#define CHICKEN_STATE_LAUNCHED	1

#define COW_STATE_NONE				0
#define COW_STATE_FLYING			1
#define COW_STATE_PIECES			2


#include <allegro.h>
#include "gfx.h"

void end_round();
void do_intro_screen();
void do_game();


typedef struct game_piece
{
	float x, y;
	float vx, vy;
	int value;
	int active;

	int state;
} game_piece;

game_piece chicken;
game_piece lame[ MAX_LAME ];

game_piece cow_part[ COW_PARTS ];
game_piece cow;
int pieces_flying_time;


//ScoreKeeping
int multiplier;
int move_score;
int score;
int draw_score_x, draw_score_y;
int rally_high;

int highest_score;
int highest_rally;

int got_highest_score;
int got_highest_rally;

int lameover;
int gameover;

int lameoverspin;
float lameoverdis;

DATAFILE *data;
BITMAP *buffer;

volatile int game_timer = 0;
void inc_game_timer()
{
	game_timer++;
} END_OF_FUNCTION( inc_game_timer );



volatile int round_timer;
void dec_round_timer()
{
	round_timer--;
} END_OF_FUNCTION( dec_round_timer );

void get_highscore()
{
	PACKFILE *file;

	file = pack_fopen( "lame.hig", "r+b" );
	pack_fread( &highest_score, sizeof( int ), file );
	pack_fread( &highest_rally, sizeof( int ), file );
	pack_fclose( file );
}

void save_highscore()
{
	PACKFILE *file;

	file = pack_fopen( "lame.hig", "w+b" );
	pack_fwrite( &highest_score, sizeof( int ), file );
	pack_fwrite( &highest_rally, sizeof( int ), file );
	pack_fclose( file );

}
/////////////////////////////////////////////////////////////////////////
void draw_game()
{
	int i;
	//Draw Wall
	drawing_mode( DRAW_MODE_COPY_PATTERN, data[ BACKGROUND ].dat, 0, 0 );
	rectfill( buffer, 0, 0, RES_X, RES_Y, 0 );
	drawing_mode( DRAW_MODE_SOLID, 0, 0, 0 );


	//Draw shadows
	//Draw chicken shadow
	draw_trans_sprite( buffer, data[ CHICKEN_SHADOW ].dat, ((chicken.x - HALF_RES_X ) / DEPTH) + HALF_RES_X, ((chicken.y - HALF_RES_Y ) / DEPTH) + HALF_RES_Y );

		//Draw lame shadows
	for ( i = 0; i < MAX_LAME; i++ )
		if ( lame[ i ].active )
				draw_trans_sprite( buffer, data[ LAME_SHADOW ].dat, ((lame[ i ].x - HALF_RES_X ) / DEPTH) + HALF_RES_X, (( lame[ i ].y - HALF_RES_Y ) / DEPTH) + HALF_RES_Y );

	//Draw Sprites
	//Draw chicken
	draw_sprite( buffer, data[ CHICKEN ].dat, (int)chicken.x, (int)chicken.y );
	//Draw lame signs
	for ( i = 0; i < MAX_LAME; i++ )
		if ( lame[ i ].active )
			draw_sprite( buffer, data[ LAME1 + lame[ i ].value ].dat, (int)lame[ i ].x, (int)lame[ i ].y );


	//Draw the cow pieces if the cow is in pieces
	if ( cow.state == COW_STATE_PIECES )
	{
		//Draw each part rotated according to that pieces value and then rotate it.
		for (i = 0; i < COW_PARTS; i++ )
		{
			rotate_sprite( buffer, data[ COW_PART1 + i ].dat, cow_part[ i ].x, cow_part[i].y, itofix(cow_part[ i ].value)  );
			cow_part[ i ].value += 15;
			//If the cow part rotated past 360 degrees then reset it back 360 degrees
			if ( cow_part[ i ].value > 255 )
				cow_part[ i ].value -= 255;
		}
	}
	//Draw the cow if the cow is in flight
	else if ( cow.state == COW_STATE_FLYING )
		draw_sprite( buffer, data[ COW ].dat, cow.x, cow.y );


	//Draw stats


	//Draw your move score if you are doing a move (ie more than one hit)
	if ( multiplier >= 0 )
	{
		textprintf_centre( buffer, data[ BIGFNT ].dat, draw_score_x + 5, draw_score_y + 5, 0, "%i x %i", move_score, multiplier );
		textprintf_centre( buffer, data[ BIGFNT ].dat, draw_score_x, draw_score_y, makecol(255,200,200), "%i x %i", move_score, multiplier );
	}
	//Draw Score
	textprintf( buffer, data[ BIGFNT ].dat, RES_X - 145, 55, 0, "Score: %i", score );
	textprintf( buffer, data[ BIGFNT ].dat, RES_X - 150, 50, makecol(200,230,255), "Score: %i", score );

	//Draw Rounds Highest Rally
	textprintf( buffer, data[ BIGFNT ].dat, RES_X - 145, 75, 0, "Best Rally: %i", rally_high );
	textprintf( buffer, data[ BIGFNT ].dat, RES_X - 150, 70, makecol(200, 230, 255), "Best Rally: %i", rally_high );

	//Draw flashy sign if you got the highest score or rally
	if ( got_highest_score )
		textout( buffer, data[ BIGFNT ].dat, "High Score!", 10, 10, makecol( (int)(rand()%255),(int)(rand()%255),(int)(rand()%255)) );
	if ( got_highest_rally )
		textout( buffer, data[ BIGFNT ].dat, "Best Rally!", 10, 30, makecol( (int)(rand()%255),(int)(rand()%255),(int)(rand()%255)) );

	//if lameover then draw the lameover sign, else, draw the round timer
	if ( lameover )
	{
		//Draw the lameover sign
		rotate_scaled_sprite( buffer, data[ LAMEOVER ].dat, (HALF_RES_X - 164), (HALF_RES_Y - 83), itofix( lameoverspin ), ftofix( lameoverdis ) );

		textout_centre( buffer, font, "Press Spacebar To Continue", HALF_RES_X, RES_Y - 100, makecol(100,100,255) );
		//Scale the lameover sign
		if ( lameoverdis < 2 )
			lameoverdis += 0.1;
		if ( lameoverspin < 255 )
			lameoverspin += 17;
		else
			lameoverspin = 255;
	}
	else
	{	//Draw Round Timer Shadow
		textprintf_centre( buffer, data[ BIGFNT ].dat, HALF_RES_X + 5, 55, 0, "%i", round_timer );
		textprintf_centre( buffer, data[ BIGFNT ].dat, HALF_RES_X, 50, makecol(255,255,255), "%i", round_timer );
	}


	blit( buffer, screen, 0, 0, 0, 0, RES_X, RES_Y );
}


/////////////////////////////////////////////////////////////////////////
void game_input()
{
	if ( !lameover )
	{
		if ( key[ KEY_ESC ] )
			end_round();
		if ( key[ KEY_LEFT ] )
				chicken.vx -= CHICKEN_SPEED;
		if ( key[ KEY_RIGHT ] )
				chicken.vx += CHICKEN_SPEED;
		if ( ( key[ KEY_SPACE ] ) && ( chicken.state == CHICKEN_STATE_UNLAUNCH ) )
		{
				chicken.vy = CHICKEN_ROCKET;
				chicken.state = CHICKEN_STATE_LAUNCHED;
		}
	}
	else
	{
		if ( key[ KEY_SPACE ] )
			gameover = 1;
		while ( key[ KEY_SPACE ] );
	}
}


void move_lame( int i )
{
	//Move lame signs according to velocities
	lame[ i ].x += lame[ i ].vx;
	lame[ i ].y += lame[ i ].vy;
}

void add_move( int sc, int xpos, int ypos )
{
	multiplier++;
	move_score += (sc+1) * LAME_SCORE_FACTOR;
	draw_score_x = xpos;
	draw_score_y = ypos;

}
void reset_move()
{
	if ( multiplier > 0 )
		score += (move_score * multiplier);

	//Set the highest rally if you got it
	if ( multiplier > highest_rally )
	{
		highest_rally = multiplier;
		got_highest_rally = 1;
	}

	//Set the high score if you got it
	if ( score > highest_score )
	{
		highest_score = score;
		got_highest_score = 1;
	}

	//Set round best rally
	if ( multiplier > rally_high )
		rally_high = multiplier;

	move_score = 0;
	multiplier = -1;

}
////////////////////////////////////////////////
void do_normal_lame( int i )
{
	move_lame( i );

	//If a leftbound lame sign goes past the left side of the screen then deactivate it
	if ( ( lame[ i ].vx < 0 ) && ( lame[ i ].x < -RES_X ) )
		lame[ i ].active = 0;

		//If a rightound lame sign goes past the rightside of the screen then deactivate it
	if ( ( lame[ i ].vx > 0 ) && ( lame[ i ].x > (RES_X * 2) ) )
		lame[ i ].active = 0;

	//If the chicken hit the lame sign then the lame sign goes flying and the chicken is bounced backwards
	if ( ( chicken.x > lame[ i ].x ) && (chicken.x < lame[ i ].x + LAME_SIZE_X)
	  && ( chicken.y > lame[ i ].y ) && (chicken.y < lame[ i ].y + LAME_SIZE_Y) )
	{
		//Make lame sign fly according to chicken speed
		if ( chicken.vy > 0 )
			lame[ i ].state = LAME_STATE_FLYING_DOWN;
		else
			lame[ i ].state = LAME_STATE_FLYING_UP;

		//Bounce chicken back
		chicken.vy *= -1;
		//Add To Multiplier
		add_move( lame[i].value, chicken.x, chicken.y );

		//Play the lame sound
		play_sample( data[ LAMESOUND ].dat, 100,  128, 650 + (lame[i].value * 150), 0 );
	}
}

void new_lame( int i )
{
	//Where the lame sign sits of the Y-axis, upto half the Y resolution
	lame[ i ].y = ( rand()%LAME_POINT );
	lame[ i ].vy = 0;
	//What colour lame sign it is (this affects speed as well )
	lame[ i ].value = (int)( rand()%5 );

	//We have 50/50 chance of having the lame sign start off-screen to the left or to the right
	if ( (rand()%100) < 50 )
	{
			lame[ i ].x = -( rand()%(RES_X * 5) );
			lame[ i ].vx = (lame[ i ].value * LAME_SPEED_FACTOR) + LAME_SPEED_FACTOR;
	}
	else
	{
			lame[ i ].x = RES_X + ( rand()%(RES_X * 5) );
			lame[ i ].vx = -(lame[ i ].value * LAME_SPEED_FACTOR) - LAME_SPEED_FACTOR;
	}

	lame[ i ].state = LAME_STATE_NORMAL;

	//Make that lame sign active
	lame[ i ].active = 1;

}

void do_flying_lame( int i )
{
	move_lame( i );

	if ( lame[ i ].state == LAME_STATE_FLYING_UP )
		lame[ i ].vy = -LAME_HIT_SPEED;
	if ( lame[ i ].state == LAME_STATE_FLYING_DOWN )
		lame[ i ].vy = LAME_HIT_SPEED;

	if ( lame[ i ].y < -RES_Y )
		lame[ i ].active = 0;
	if ( lame[ i ].y > RES_Y * 2 )
		lame[ i ].active = 0 ;
}

void do_chicken()
{
	//Move chicken Velocities
	chicken.x += chicken.vx;
	chicken.y += chicken.vy;

	//Move Chicken Friction
	chicken.vx *= FRICTION;

	//Bounce Chicken Off The Wall
	if ( chicken.x <= 0 )
		chicken.vx *= -1;
	if ( chicken.x >= RES_X )
		chicken.vx *= -1;

	//If chicken is below launching point then slowly move him forward
	if ( chicken.y > RES_Y - 40 )
		chicken.vy = -10;
	else
		//If the chicken is aproximately at the launching point then put him there and get him ready to launch
		if ( chicken.y > RES_Y - 50 )
		{
			chicken.vy = 0;
			chicken.y = RES_Y - 50;
			chicken.state = CHICKEN_STATE_UNLAUNCH;

			//Reset Multiplier and add to score
			reset_move();
		}


	//If chicken is vaulted off screen then make a sound a return chicken
	if ( chicken.y < -HALF_RES_Y )
	{
		play_sample( data[ CHICKENSOUND ].dat, 255, 128, 1000, 0 );
		chicken.y = HALF_RES_Y * 3;
	}

}

void do_cow()
{
	int i;
	//if cow is active then do his stuff
	if ( cow.state == COW_STATE_FLYING )
	{

		//Move cow
		cow.x += cow.vx;
		cow.y += cow.vy;

		//If the cow goes off screen then get rid of him
		if ( cow.x < -RES_X )
			cow.state = COW_STATE_NONE;

		//If the chicken hits the cow, then
		if (  (chicken.x > cow.x) && (chicken.y > cow.y) && (chicken.x < cow.x + COW_SIZE_X ) && (chicken.y < cow.y + COW_SIZE_Y) )
		{
			//Make all of the new cow pieces
			cow_part[ 0 ].x = cow.x;		cow_part[ 1 ].x = cow.x + 52;	cow_part[ 2 ].x = cow.x + 85;
			cow_part[ 0 ].y = cow.y + 4;	cow_part[ 1 ].y = cow.y;		cow_part[ 2 ].y = cow.y + 100;
			cow_part[ 0 ].vx = -8;			cow_part[ 1 ].vx =  8;			cow_part[ 2 ].vx = 0;
			cow_part[ 0 ].vy = -8;			cow_part[ 1 ].vy = -8;			cow_part[ 2 ].vy =-2;

			cow_part[ 3 ].x = cow.x + 23; cow_part[ 4 ].x = cow.x + 24;	cow_part[ 5 ].x = cow.x + 98;
			cow_part[ 3 ].y = cow.y;		cow_part[ 4 ].y = cow.y + 35;	cow_part[ 5 ].y = cow.y + 15;
			cow_part[ 3 ].vx =  0;			cow_part[ 4 ].vx =  0;			cow_part[ 5 ].vx = 4;
			cow_part[ 3 ].vy = -2;			cow_part[ 4 ].vy = -2;			cow_part[ 5 ].vy  -4;

			cow_part[ 6 ].x = cow.x + 114;cow_part[ 7 ].x = cow.x + 41;	cow_part[ 8 ].x = cow.x + 130;
			cow_part[ 6 ].y = cow.y + 100;cow_part[ 7 ].y = cow.y + 102;cow_part[ 8 ].y = cow.y + 115;
			cow_part[ 6 ].vx = -4;			cow_part[ 7 ].vx =  0;			cow_part[ 8 ].vx = 8;
			cow_part[ 6 ].vy = -2;			cow_part[ 7 ].vy =  0;			cow_part[ 8 ].vy = 4;

			cow_part[ 9 ].x = cow.x + 76;
			cow_part[ 9 ].y = cow.y + 19;
			cow_part[ 9 ].vx = 0;
			cow_part[ 9 ].vy = 0;

			cow.state = COW_STATE_PIECES;
			cow.active = 1;

			//Bounce Chicken
			chicken.vy *= -1;

			//Reset the amount of time the cow pieces have been out for
			pieces_flying_time = 0;

			//Add points to score
			add_move( COW_WORTH, chicken.x, chicken.y );

			stop_sample( data[ DEADCOW ].dat );
			play_sample( data[ COWBONUS ].dat, 255, 128, 1000, 0 );

		}
	}
	//When the cow is in pieces
	else if ( cow.state == COW_STATE_PIECES )
	{
		//Add how long pieces have been flying by 1
		pieces_flying_time++;

		//If the pieces have been out for long enough then reset the cow's state
		if ( pieces_flying_time > TIME_PIECES )
			cow.state = COW_STATE_NONE;


		//Move every cow piece
		for ( i = 0; i < COW_PARTS; i++ )
		{
			cow_part[ i ].x += cow_part[ i ].vx;
			cow_part[ i ].y += cow_part[ i ].vy;
			cow_part[ i ].vy += 0.98;		//Gravity
		}

	}
	//If cow is not active, then make him active upon randomness
	else if ( cow.state == COW_STATE_NONE )
		if ( (int)( rand()%COW_CHANCE) <= 1 )
		{
			cow.x = RES_X * 2;
			cow.y = COW_POINT;
			cow.vx = COW_SPEED;
			cow.vy = 0;
			cow.state = COW_STATE_FLYING;
			cow.value = 100;
			cow.active = 1;

			//Play Mad Cow Sample!!
			play_sample( data[ DEADCOW ].dat, 255, 128, 1000, 0 );
		}


}

void game_logic()
{
	int i;

	do_chicken();

	//Do Lame Signs
	for ( i = 0; i < MAX_LAME; i++ )
	{
		//If the lame sign is not active then we must set all of it's values
		if ( !lame[ i ].active )
			new_lame( i );

		if ( lame[ i ].state == LAME_STATE_NORMAL )
			do_normal_lame( i );
		else
			do_flying_lame( i );
	}

	do_cow();

	//If the timer reaches 0 then end
	if ( (round_timer <= 0 ) & (!lameover ) )
		end_round();

}



void exit_system()
{
	save_highscore();
	destroy_bitmap( buffer );
	unload_datafile( data );
	allegro_exit();
	exit( 0 );
}

void init_game()
{
	int i;

	chicken.x = RES_X / 2;
	chicken.y = RES_Y + 100;
	chicken.vx = 0;
	chicken.vy = 0;
	chicken.active = 1;
	chicken.value = CHICKEN;

	for ( i = 0; i < MAX_LAME; i++ )
		lame[ i ].active = 0;

	LOCK_VARIABLE( round_timer );
	LOCK_FUNCTION( dec_round_timer );
	install_int_ex( dec_round_timer, BPM_TO_TIMER( 60 ) );

	round_timer = ROUND_SECONDS;
	multiplier = -1;
	move_score = 0;
	score = 0;
	got_highest_score = 0;
	got_highest_rally = 0;
	rally_high = 0;


}

void end_round()
{
	lameover = 1;
	play_sample( data[ STIKIT ].dat, 255, 128, 1000, 0 );
}

void do_game()
{
	gameover = 0;
	lameover = 0;
	lameoverspin = 0;
	lameoverdis = 0;

	init_game();
	while ( !gameover )
	{
		while ( game_timer > 0 )
		{
			game_input();
			game_logic();
			game_timer--;
		}
		draw_game();
	}

	do_intro_screen();
	do_game();
}





////////////////////////////////////////////////////////////////
#define X_POINT	300
#define Y_POINT	240
#define NUM_STARS	1000

void do_intro_screen()
{
	int i;
	float xx, yy;
	float ang, dis;

	int px[ NUM_STARS ];
	int py[ NUM_STARS ];
	int pv[ NUM_STARS ];

	int on_screen = 0;
	int show_help = 0;

	for ( i = 0; i < NUM_STARS; i++ )
	{
		px[ i ] = (int)(rand()%(RES_X * 2) );
		py[ i ] = (int)(rand()%RES_Y);
		pv[ i ] = (int)(rand()%255) + 1;
	}
	ang = 0;
	dis = 200;

	vsync();

	LOCK_VARIABLE( game_timer );
	LOCK_FUNCTION( inc_game_timer );
	install_int_ex( inc_game_timer, BPS_TO_TIMER( 60 ) );

	play_sample( data[ LAMELAND ].dat, 255, 128, 1000, 0 );

	while( !key[ KEY_SPACE ] )
	{
		while (game_timer > 0 )
		{
			//Toggle Help
			if ( key[ KEY_F1 ] )
			{
				show_help = !show_help;
				while ( key[ KEY_F1 ] );
			}

			//Increment the amount of time it has been on specific screen for (highscore or lame intro)
			on_screen++;
			if (on_screen > 800 )
			{
				on_screen = 0;
				dis = 200;
			}

			//If the user presses escape then unload game
			if ( key[ KEY_ESC ] )
			{
				exit_system();
			}

			//The spiralling of the lame sign
			if( dis > 0 )
			{
				ang += 0.1;
				xx = X_POINT + (cos(ang) * dis);
				yy = Y_POINT + (sin(ang) * dis);
			}
			dis -= 1.75;		//+ distance = spiralling sign | - distance = Growing Sign

			//Do star field
			for ( i = 0; i < NUM_STARS; i++ )
			{
				px[ i ] -= (pv[ i ] / 50 );
				if ( px[ i ] < 0 )
					px[ i ] = RES_X * 2;
			}
			game_timer--;
		}

		clear( buffer );

		//Draw Starfield
		for ( i = 0; i < NUM_STARS; i++ )
			putpixel( buffer, px[ i ], py[ i ], makecol( pv[ i ], pv[ i ], pv[ i ] ) );


		if ( !show_help )
		{
			if ( on_screen < 400 )
				//Draw lame sign
				if ( dis > 0 )
					draw_sprite( buffer, data[ LAMELAND_SIGN ].dat, xx, yy );
				else
					masked_stretch_blit( data[ LAMELAND_SIGN ].dat, buffer, 0, 0, 287, 44, xx + dis, yy + dis, 287 - ( dis*2 ), 44 - (dis * 2) );
			else
			{
				textprintf_centre( buffer, data[ BIGFNT ].dat, HALF_RES_X, HALF_RES_Y - 25, makecol( (int)(rand()%255),(int)(rand()%255),(int)(rand()%255)), "High Score: %i", highest_score );
				textprintf_centre( buffer, data[ BIGFNT ].dat, HALF_RES_X, HALF_RES_Y + 25, makecol( (int)(rand()%255),(int)(rand()%255),(int)(rand()%255)), "Longest Rally: %i", highest_rally );
			}

			//Display score if this isn't first time around
			if ( score > 0 )
			{
				textprintf_centre( buffer, data[ BIGFNT ].dat, HALF_RES_X, 100, makecol(150,150,255), "Score: %i", score );
				textprintf_centre( buffer, data[ BIGFNT ].dat, HALF_RES_X, 120, makecol(150,150,255), "Best Rally: %i", rally_high );
			}

			textout_centre( buffer, data[ BIGFNT ].dat, "Press Spacebar To Play", HALF_RES_X, HALF_RES_Y + 100, makecol( 0, 100, 255 ) );
			textout_centre( buffer, data[ BIGFNT ].dat, "Press F1 For Help", HALF_RES_X, RES_Y - 25, makecol( 100, 100, 50 ) );
		}
		else
		{
			//Help Screen
			textout( buffer, data[ BIGFNT ].dat, "Lame Land - By Daniel McKinnon", 																				10,25,		makecol(255,255,255) );
			textout( buffer, font, "Get ready for the lamest experience of your life!", 													10,50,		makecol(255,255,255 ) );
			textout( buffer, font, "In the all new action-packed game LAME LAND", 															10,75,		makecol(255,255,255 ) );

			textout( buffer, font, "Alright,  you've got a rubber chicken who is out to destroy pestering lame signs,",			10,125,		makecol(255,255,255 ) );
			textout( buffer, font, "So what you've got to do is bounce your rubber chicken's beak off of two or",					10,150,		makecol(255,255,255 ) );
			textout( buffer, font, "more lame signs in order to score points.", 																10,175,		makecol(255,255,255 ) );
			textout( buffer, font, "Now, you see, your rubber chicken also has a disliking for cows as well, so", 					10,200,		makecol(255,255,255 ) );
			textout( buffer, font, "I threw in a couple of cows to make things interesting.", 											10,225,		makecol(255,255,255 ) );
			textout( buffer, font, "The cows, however, are worth points in the same fashion as lame signs.", 						10,250,		makecol(255,255,255 ) );

			textout( buffer, font, "So here it is in a nutshell:", 																				10,300,		makecol(255,255,255 ) );
			textout( buffer, font, "For every time you bounce your rubber chicken off of a lame sign you get a multiplier", 	10,325,		makecol(255,255,255 ) );
			textout( buffer, font, "once you are done your rally and your chicken goes off screen, your score will increment",10,350,		makecol(255,255,255 ) );
			textout( buffer, font, "by (rally score) x (multiplier).  Got it... Good", 													10,375,		makecol(255,255,255 ) );

			textout( buffer, font, "Last point of lameness.  What's up with the shadows?", 												10,425,		makecol(255,255,255 ) );
			textout( buffer, data[ BIGFNT ].dat, "Now just play the damn game, it's not that hard.", 									10,475,		makecol(255,255,255 ) );
		}


		blit( buffer, screen, 0, 0, 0, 0, RES_X, RES_Y );
	}
}



int main(void)
{
	//Install Allegro
	allegro_init();

	//Setup Inputs
	install_keyboard();
	install_mouse();

	//Install Sound Drivers
	if ( detect_digi_driver( DIGI_AUTODETECT ) )
	{
			reserve_voices( 5, 0 );
			install_sound( DIGI_AUTODETECT, MIDI_NONE, "" );
	}

	set_color_depth( 16 );
	if ( set_gfx_mode( GFX_AUTODETECT, RES_X, RES_Y, 0, 0 ) < 0 )
		exit( 5 );

	data = load_datafile( "lame.dat" );
	buffer = create_bitmap( RES_X, RES_Y );
	text_mode( -1 );

	set_trans_blender( 0, 0, 0, LIGHTNESS );

	get_highscore();

	do_intro_screen();
	do_game();

	exit_system();
} END_OF_MAIN();


