// allegro_message() wrapper class allowing stream output.
// (Part of Wormlings)
// -----------------------------------------------------------------------------
// $Revision: 157 $ $Date: 2005-03-04 11:07:14 +0100 (fr, 04 mar 2005) $
// -----------------------------------------------------------------------------
// Copyright 2005 Daniel Schlyder.
// Distributed under the GNU General Public License; as published by the Free
// Software Foundation; either version 2 of the License, or (at your option) any
// later version. (See accompanying file LICENSE.txt or copy at
// http://www.gnu.org/licenses/gpl.html)



#ifndef WORMLINGS_ALERTSTREAM_HPP
#define WORMLINGS_ALERTSTREAM_HPP



#include <allegro.h>

#include <sstream>



class alertstream
{
    public:
    
    ~alertstream()
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        m_stream << "\n\n";
        allegro_message(m_stream.str().c_str());
    }
    
    template <typename T>
    alertstream &operator<<(T const &in)
    {
        m_stream << in;
        return *this;
    }
    
    
    private:
    
    std::ostringstream m_stream;
};



#endif // #ifndef WORMLINGS_ALERTSTREAM_HPP
