@rem Converts line breaks to DOS CR/LF format and configures JPGalleg to be
@rem built under specified platform. Derived from the Allegro version of this
@rem same script.

@echo off

rem Test if there are too many args.
if [%3] == []        goto arg2
goto help

:arg2
rem Test if second arg is ok.
if [%2] == [--quick] goto arg1
if [%2] == []        goto arg1
goto help

:arg1
rem Test if first arg is ok.
if [%1] == [djgpp]   goto head
if [%1] == [mingw32] goto head
if [%1] == [msvc]    goto head
goto help

:head
rem Generate header of makefile
echo # generated by fix.bat > makefile

if [%1] == [djgpp]   goto djgpp
if [%1] == [mingw32] goto mingw32
if [%1] == [msvc]    goto msvc

echo fix.bat internal error: not reached
goto help

:djgpp
echo Configuring JPGalleg for DOS/djgpp...
echo MAKEFILE_INC = makefile.dj >> makefile
goto tail

:mingw32
echo Configuring JPGalleg for Windows/Mingw32...
echo MAKEFILE_INC = makefile.mgw >> makefile
goto tail

:msvc
echo Configuring JPGalleg for Windows/MSVC...
echo MAKEFILE_INC = makefile.vc >> makefile
goto tail

:help
echo.
echo Usage: fix platform [--quick]
echo.
echo Where platform is one of: djgpp, mingw32, msvc.
echo The --quick parameter is used to turn off LF to CR/LF conversion.
echo.
goto end

:tail
rem Generate last line of makefile and optionally convert CR/LF.
echo include makefile.all >> makefile

if [%2] == [--quick] goto done
if [%1] == [mingw32] goto done
if [%1] == [msvc]    goto done

echo Converting JPGalleg files to DOS CR/LF format...
utod .../*.bat .../*.sh .../*.c .../*.s .../*.h .../*.txt
utod .../*.inc .../*.scm .../*.scr .../*.scu makefile.*

:done
echo Done!

:end
