// Wormlings core game routines.
// -----------------------------------------------------------------------------
// $Revision: 152 $ $Date: 2005-03-04 05:48:32 +0100 (fr, 04 mar 2005) $
// -----------------------------------------------------------------------------
// Copyright 2000-2005 Daniel Schlyder.
// Distributed under the GNU General Public License; as published by the Free
// Software Foundation; either version 2 of the License, or (at your option) any
// later version. (See accompanying file LICENSE.txt or copy at
// http://www.gnu.org/licenses/gpl.html)



#ifndef WORMLINGS_GAME_HPP
#define WORMLINGS_GAME_HPP



#include "audio.hpp"

#include <string>



// config. variables
extern int
    playersNum,
    playersSize,
    playersMaxLength,
    playersSlowGrowth,
    playersTurnSpeed,
    powerMax,
    powerRegainSpeed,
    eraseTheDead,
    ballsAmount,
    scoreLimit;

extern bool display_fps_counter;

// wormling position (each wormling consist of a number of these)
struct pos
{
    int x, y;
    pos *next, *prev;
};

// player info
struct player
{
    std::string name;
    double x, y;
    int
        col,
        direction,
        dead,
        length,
        eraseTail,
        keyLeft, keyRight, keyTurbo, keyStop,
        power,
        speed,
        score;
    pos *head, *tail;
    sample_id last_sid;
};

extern player players[4];



void setPlayersColour();

// Start/run game.
void game();



#endif // #ifndef WORMLINGS_GAME_HPP
