// -----------------------------------------------------------------------------
// $Revision: 148 $ $Date: 2005-03-03 12:43:04 +0100 (to, 03 mar 2005) $
// -----------------------------------------------------------------------------
// Copyright 2000-2005 Daniel Schlyder.
// Distributed under the GNU General Public License; as published by the Free
// Software Foundation; either version 2 of the License, or (at your option) any
// later version. (See accompanying file LICENSE.txt or copy at
// http://www.gnu.org/licenses/gpl.html)



#include <allegro.h>

#include <cassert>



volatile int latency;



namespace {

void incLatency();

} // namespace



void startLatencyTimer(int bps)
{
    // remember latency interrupt frequency
    static int bpsCurrent(0);
    
    // uninstall first, if previously installed
    if (bpsCurrent)
    {
        remove_int(incLatency);
    }
    
    if (bps)
    {
        bpsCurrent = bps;
    }
    assert(bpsCurrent);
    
    install_int_ex(incLatency, BPS_TO_TIMER(bpsCurrent));
}



void stopLatencyTimer()
{
    remove_int(incLatency);
}



namespace {

void incLatency()
{
    ++latency;
}

} // namespace
