// Wormlings graphics routines.
// -----------------------------------------------------------------------------
// $Revision: 156 $ $Date: 2005-03-04 10:38:49 +0100 (fr, 04 mar 2005) $
// -----------------------------------------------------------------------------
// Copyright 2000-2005 Daniel Schlyder.
// Distributed under the GNU General Public License; as published by the Free
// Software Foundation; either version 2 of the License, or (at your option) any
// later version. (See accompanying file LICENSE.txt or copy at
// http://www.gnu.org/licenses/gpl.html)



#ifndef WORMLINGS_GRAPHICS_HPP
#define WORMLINGS_GRAPHICS_HPP



#include <allegro.h>

#include <string>



#if (ALLEGRO_VERSION == 4 \
    && ALLEGRO_SUB_VERSION <= 1 \
    && ALLEGRO_WIP_VERSION <= 3)
#define USE_OLD_TEXT_API
#endif



extern BITMAP
    *buffer,        // double buffer
    *background,
    *logo,
    *g_bmp_char,
    *g_bmp_countdown;

// Whether game should be run in windowed or fullscreen graphics mode.
extern bool runWindowed;

extern int g_colour_depth;



// init game graphics (set mode, load images, create bitmaps...)
bool initGraphics();

// free memory used by graphics
void shutdownGraphics();

// blit buffer to screen
void displayBuf();

void screenshot();

// print text with ugly drop shadow using Allegro's textout functions
void print(
    BITMAP *bmp, FONT *font, int x, int y, int col,
    std::string const &text, int align = 0, int shadowOffset = 1
);

// print centred text with middle part in different colour than the rest
void printMultiColCentred(
    BITMAP *bmp, FONT *fnt, int x, int y,
    int colMiddle, int colSurround, std::string const &start,
    std::string const &middle, std::string const &end
);

// calls Allegro's do_line() for each horizontal line in a circle
// ie. the supplied function will be called for all points within the circle,
// and not just the circle itself (as Allegro's do_circle() does)
void doCircleFill(
    BITMAP *bmp, int x, int y, int r, int d,
    void (*proc)(BITMAP *, int, int, int)
);

// return darker version of <col> colour
int getDarkerCol(int col);



#endif // #ifndef WORMLINGS_GRAPHICS_HPP
