; Inno Setup script for Wormlings.
; ------------------------------------------------------------------------------
; $Revision: 166 $ $Date: 2005-03-04 14:13:01 +0100 (fr, 04 mar 2005) $
; ------------------------------------------------------------------------------
; Copyright 2003-2005 Daniel Schlyder.
; Distributed under the GNU General Public License; as published by the Free
; Software Foundation; either version 2 of the License, or (at your option) any
; later version. (See accompanying file LICENSE.txt or copy at
; http://www.gnu.org/licenses/gpl.html)



[Setup]
SourceDir=..\..\..\
OutputBaseFilename=wormlings-3.0-setup
OutputDir=dist
Compression=lzma
SolidCompression=yes

AppName=Wormlings
AppVersion=3.0
AppVerName=Wormlings version 3.0
AppPublisher=Daniel Schlyder
AppContact=support@bitblaze.com
AppReadmeFile={app}\readme.html
AppUpdatesURL=http://bitblaze.com/

DefaultDirName={pf}\Wormlings
DefaultGroupName=Games\Wormlings
TimeStampsInUTC=yes

ShowLanguageDialog=yes
WizardImageFile=src\build\windows-setup\setup-large.bmp
WizardSmallImageFile=src\build\windows-setup\setup-small.bmp

LicenseFile=LICENSE.txt

UninstallDisplayIcon={app}\wormlings.exe
UninstallFilesDir={app}\uninstaller


[Tasks]
Name: desktopicon; Description: Create &desktop icon; GroupDescription: Additional icons:


[Files]
Source: wormlings.exe; DestDir: {app}
Source: readme.html; DestDir: {app}
Source: LICENSE.txt; DestDir: {app}
Source: data\*; Excludes: ".svn"; DestDir: {app}\data; Flags: recursesubdirs


[INI]
Filename: {app}\Product Updates.url; Section: InternetShortcut; Key: URL; String: http://bitblaze.com/


[Icons]
Name: {userdesktop}\Wormlings; Filename: {app}\wormlings.exe; Tasks: desktopicon; Comment: Play Wormlings; WorkingDir: {app}

Name: {group}\Wormlings; Filename: {app}\wormlings.exe; Comment: Play Wormlings; WorkingDir: {app}
Name: {group}\Product Updates; Filename: {app}\Product Updates.url; Comment: Visit Bitblaze.com for news and updates
Name: {group}\Readme; Filename: {app}\readme.html; Comment: View readme


[Run]
Filename: {app}\readme.html; Description: View Readme; Flags: postinstall shellexec skipifsilent


[UninstallDelete]
Type: files; Name: {app}\Product Updates.url

