// Wormlings audio routines singleton class.
// -----------------------------------------------------------------------------
// $Revision: 161 $ $Date: 2005-03-04 11:43:07 +0100 (fr, 04 mar 2005) $
// -----------------------------------------------------------------------------
// Copyright 2005 Daniel Schlyder.
// Distributed under the GNU General Public License; as published by the Free
// Software Foundation; either version 2 of the License, or (at your option) any
// later version. (See accompanying file LICENSE.txt or copy at
// http://www.gnu.org/licenses/gpl.html)



#ifndef WORMLINGS_AUDIO_HPP
#define WORMLINGS_AUDIO_HPP



#include <allegro.h>

#include <map>
#include <string>



enum sample_id
{
    sid_ball_bounce,
    sid_countdown,
    sid_countdown_done,
    sid_menu_loop,
    sid_wormling_death,
    sid_wormling_stop,
    sid_wormling_turbo,
    sid_end
};



class audio
{
    public:
    
    ~audio();
    
    static audio &instance()
    {
        static audio object;
        return object;
    }
    
    bool init();
    void exit();
    
    // The play functions volume parameter is multiplied by the global volume to
    // calculate real volume. Values is clamped to [0.0 .. 1.0].
    void play(
        sample_id sid, float volume = 1.0, unsigned char pan = 128,
        int freq = 1000, bool loop = false
    );
    void play_at_x(
        sample_id sid, double x, float volume = 1.0, int freq = 1000,
        bool loop = false
    );
    void stop(sample_id sid);
    
    int volume() const;
    bool set_volume(int volume);
    bool adjust_volume(int amount);
    
    
    private:
    
    bool m_initialised;
    int m_volume;
    SAMPLE *m_samples[sid_end];
    
    // This stuff is ugly. It would be better to use Allegro's voice functions.
    typedef std::multimap<sample_id, unsigned> sid_voice_multimap;
    typedef sid_voice_multimap::value_type sid_voice;
    sid_voice_multimap m_looping_samples;
    
    audio();
    audio(audio const &);
    audio &operator=(audio const &);
    
    void load_sample(sample_id sid, std::string const &basename);
};



#endif // #ifndef WORMLINGS_AUDIO_HPP
