/*
 * Wormhole effect
 * by Jon Rafkind
 * email: workmin@ccs.neu.edu
 *
 * last modifed December 2, 2002 
 * 
 * You are free to use this code for whatever purpose you like.
 * No gaurantee that the program will not destroy your monitor, computer,
 * dog, or marriage.
 * 
 */


#include <allegro.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <stdio.h>

#define WORM_MOVE 9.3
#define screen_x 640
#define screen_y 480
#define si 1000
#define MAX_STAR 1500
#define Z_SPEED 9
#define MAX_Z 550

volatile int speed_counter = 0;

double tcos[ 360 ];
double tsine[360 ];
BITMAP * work;

void inc_speed_counter(){
	speed_counter++;
}
END_OF_FUNCTION( inc_speed_counter );


void set_trig(){
	for ( int r = 0; r<360; r++ ){ 
		tcos [ r ]  = cos( (double)(r) * M_PI / 180.0 );
		tsine[ r ]  =-sin( (double)(r) * M_PI / 180.0 );
	}
}

int rnd( int q ) {

        return random() % q;

	/*
        #else

        return (int)( q * ( (double)rand() / ( (double)RAND_MAX + 1.0 ) ) );
        #endif
	*/

}

void blend_palette( int * pal, int mp, int sc, int ec ) {

        int sc_r = getr( sc );
        int sc_g = getg( sc );
        int sc_b = getb( sc );

        int ec_r = getr( ec );
        int ec_g = getg( ec );
        int ec_b = getb( ec );

        for ( int q = 0; q < mp; q++ ) {
                float j = (float)( q ) / (float)( mp );
                int f_r = (int)( 0.5 + (float)( sc_r ) + (float)( ec_r-sc_r ) * j );
                int f_g = (int)( 0.5 + (float)( sc_g ) + (float)( ec_g-sc_g ) * j );
                int f_b = (int)( 0.5 + (float)( sc_b ) + (float)( ec_b-sc_b ) * j );
                pal[q] = makecol( f_r, f_g, f_b );
        }

}

int gang( int x1, int y1, int x2, int y2 ){

	int tang;
	if ( x1 == x2 ){
		if ( y1 < y2 )
			tang = 90;
		else
			tang = 270;
	}	else	tang = (int)( 0.5 + atan2( -(y2 - y1), x2 - x1 ) * 180.0 / M_PI );

	while ( tang < 0 )
		tang += 360;
	return tang % 360;
}

class StarClass{
public:
	StarClass( const int x, const int y, const int z, const int mx, const int my ):
		actualx( x ),
		actualy( y ),
		cx( mx ),
		cy( my ),
		Z( z ){
			ReCalc();
		}

	int GetZ(){
		return Z;
	}

	int GetX(){
		return virtualx;
	}

	int GetY(){
		return virtualy;
	}

	void CalcX(){
		if ( Z <= 0 )
			virtualx = si * actualx / cx;
		else
			virtualx = si * actualx / Z + cx;
	}

	void CalcY(){
		if ( Z <= 0 )
			virtualy = si * actualy / cy;
		else
			virtualy = ( si * actualy ) / Z + cy;
	}

	void ReCalc(){
		CalcX();
		CalcY();
	}

	bool Update(){

		Z-=Z_SPEED;
		return ( Z <= 0 || !inbox() );
	}

	bool inbox(){
		return ( virtualx > 0 && virtualx < screen_x &&
			virtualy > 0 && virtualy < screen_y );
	}

protected:
	int actualx;
	int actualy;
	int virtualx;
	int virtualy;
	int cx;
	int cy;
	int Z;
};

class StarLine{
public:

	StarLine( int scale, int mx, int my ){
		int qz = MAX_Z;
		int ang = rnd(360);
		for ( int q = 0; q < 2; q++ )
			star[q] = new StarClass( 
			(int)(tcos[ang]*scale),
			(int)(tsine[ang]*scale),
			qz-q*(rnd(6)+4), mx, my ); 
	}

	StarLine( int scale, int mx, int my, int ang, int qz ){
		for ( int q = 0; q < 2; q++ )
			star[q] = new StarClass(
			(int)(tcos[ang]*scale),
			(int)(tsine[ang]*scale),
			qz-q*(rnd(5)+3), mx, my );
	}

	bool Update( ){

		bool cy = false;
		for ( int q = 0; q < 2; q++ )
			cy = cy || star[q]->Update();
		return cy;
	
	}

	void Draw( int * shade, int max_shade ){
		for ( int q = 0; q < 2; q++ )
			star[q]->ReCalc();
		int ncolor = (int)( (double)star[0]->GetZ() * (double)(max_shade-1) / (double)MAX_Z);
		line( work, star[0]->GetX(), star[0]->GetY(), star[1]->GetX(), star[1]->GetY(), shade[ncolor]);
	}

	~StarLine(){
		for ( int q = 0; q < 2; q++ )
			delete star[q];
	}

protected:

	StarClass * star[ 2 ];

};

class StarNode{
public:
	StarNode( StarLine * st ){
		next = NULL;
		star = st;
	}

	void add( StarNode * who ){
		next = who;
	}

	StarNode * Next(){
		return next;
	}

	StarLine * Get(){
		return star;
	}

	~StarNode(){
		delete star;
	}

protected:
	StarNode * next;
	StarLine * star;
};

class RGBHandle{
public:

#define RGB_GO_BLACK 12
#define RGB_SWITCH 15
	RGBHandle(){

		rwant = rnd( 255 );
		gwant = rnd( 255 );
		bwant = rnd( 255 );

		mine.r = rwant;
		mine.g = gwant;
		mine.b = bwant;
		
	}

	bool changecol( unsigned char & c, unsigned char & dir ){

		for ( int q = 0; q < 2; q++ ){
			if ( c > dir ) c--;
			if ( c < dir ) c++;
		}

		return c == dir;

	}

	void update( int max, int min ){

		unsigned char * want[ 3 ];
		want[0] = &rwant;
		want[1] = &gwant;
		want[2] = &bwant;

		if ( changecol( mine.r, rwant ) ){
			if ( rnd( RGB_GO_BLACK ) == rnd( RGB_GO_BLACK ) )
				rwant = 0;
			else	rwant = rnd(max-min)+min;
		}
		
		if ( changecol( mine.g, gwant ) ){
			if ( rnd( RGB_GO_BLACK ) == rnd( RGB_GO_BLACK ) )
				gwant = 0;
			else	gwant = rnd(max-min)+min;
		}
		
		if ( changecol( mine.b, bwant ) ){
			if ( rnd( RGB_GO_BLACK ) == rnd( RGB_GO_BLACK ) )
				bwant = 0;
			else	bwant = rnd(max-min)+min;
		}
		
		bool cy = false;
		for ( int q = 0; q < 3; q++ )
			cy = cy || (*(want[q]) >= min && *(want[q]) <= max);
		if ( !cy ) *(want[rnd(3)]) = rnd(max-min)+min;
		cy = true;
		for ( int q = 0; q < 3; q++ )
			cy = cy && *(want[q]) == 0;
		if ( cy ) *(want[rnd(3)]) = rnd(max-min)+min;


	}
	
	int Get( ){
		return makecol( mine.r, mine.g, mine.b );
	}

protected:
	RGB mine;
	unsigned char rwant, gwant, bwant;
};

class ColorChanger{
public:

	ColorChanger( int m ){
		max = m;
		shade = new int[ m ];

		c1 = new RGBHandle();
		c2 = new RGBHandle();

		blend_palette( shade, max, c1->Get(), c2->Get() );

	}

	void update(){

		c1->update( 255, 180 );
		c2->update( 130, 40 );

		blend_palette( shade, max, c1->Get(), c2->Get() );
	}

	int * Colors(){
		return shade;
	}

	int MAXCOLORS(){
		return max;
	}

	~ColorChanger(){
		delete[] shade;
		delete c1;
		delete c2;
	}

protected:
	int * shade;
	int max;

	RGBHandle * c1, * c2;
	
};

class WormHole{
public:
	WormHole(){
		spiral = 0;
		actualx = rnd(640);
		actualy = rnd(480);
		virtualx = actualx;
		virtualy = actualy;
		zsize = rnd( 20 ) + 25;
		msize = zsize;
		ang = rnd( 360 );
		head = new StarNode( NULL );
		very_last = head;
		x_col = new ColorChanger( 30 );

		/*
		words = create_bitmap( text_length(font,"Jon Rafkind"), 11 );
		clear_to_color( words, makecol(0,0,0) );
		textprintf( words, font, 0, 0, makecol(255,255,255), "Jon Rafkind");
		printing = false;
		*/
		
	}

	void Update(){
		if ( !spiral ){
			ang = ( ang + rnd( 30 ) - 15 + 360 ) % 360;
			if ( rnd( 20 ) == rnd( 20 ) )
				ang = rnd( 360 );
		} else {
			ang = ( ang + 15 ) % 360;
			spiral--;
		}
		if( rnd( 120 ) == rnd( 120 ) )
			spiral = rnd( 30 ) + 35;

		if ( actualx < 20 || actualy < 20 || actualx > screen_x-20 ||
			actualy > screen_y - 20 )
				ang = gang( actualx, actualy, screen_x/2, screen_y/2 );
		virtualx += tcos[ ang ] * WORM_MOVE;
		virtualy += tsine[ang ] * WORM_MOVE;
		actualx = (int)virtualx;
		actualy = (int)virtualy;

		if ( rnd( 20 ) == rnd( 20 ) )
			msize = rnd( 40 ) + 5;
		if ( zsize < msize )
			zsize++;
		if ( zsize > msize )
			zsize--;

		for ( int q = 0; q < 60; q++ )
			add( new StarNode( new StarLine(zsize,actualx,actualy) ) );

		/*
		if ( printing ){

			if ( scount >= 0 ){
			
				int sdir;
				if ( sang <= 90 || sang >= 270 ) sdir = -1;
				else sdir = 1;
				for ( int y = 0; y < 11; y++ )
					if ( getpixel(words,print_x,y) == makecol(255,255,255) ){
						putpixel( work, print_x, y, makecol(255,255,255) );
						add( new StarNode( new StarLine(zsize,actualx,actualy,(ang+y*sdir+360)%360, MAX_Z ) ) );
					}
				print_x--;
				if ( print_x <= 0 ) printing = false;
				scount = 0;
			} else scount++;
			
		}

		if ( !printing && (rnd(10) == rnd(10) ) ){
			print_x = text_length(font,"Jon Rafkind")-1;
			sang = rnd( 360 );
			printing = true;
			scount = 0;
		}
		*/

		StarNode * junk = head->Next();
		StarNode * hold = head;
		while ( junk != NULL ){
			if ( junk->Get()->Update() ){
				hold->add( junk->Next() );
				if ( junk == very_last ) very_last = hold;
				delete junk;
				junk = NULL;
			}
			hold = hold->Next();
			if ( hold != NULL ) junk = hold->Next();
		}
		
		x_col->update();
		
	}

	void add( StarNode * temp ){
		StarNode * junk = very_last;
		while ( junk->Next() != NULL ) junk = junk->Next();
		junk->add( temp );
		very_last = junk->Next();
	}

	void Draw(){

		StarNode * junk = head->Next();
		while ( junk != NULL ){
			junk->Get()->Draw( x_col->Colors(), x_col->MAXCOLORS() );
			junk = junk->Next();
		}

	}

	~WormHole(){
		StarNode * junk = head;
		while( junk != NULL ){
			StarNode * last = junk;
			junk = junk->Next();
			delete last;
		}
	}


protected:
	int zsize;
	int msize;
	int actualx, actualy;
	int ang;
	int spiral;
	double virtualx, virtualy;
	StarNode * head;
	StarNode * very_last;
	ColorChanger * x_col;
	BITMAP * words;

	bool printing;
	int print_x;
	int sang;
	int scount;
};

void init(){
	allegro_init();
	srandom( time( NULL ) );
	install_timer();
	install_keyboard();
	set_color_depth( 16 );
	set_gfx_mode( GFX_AUTODETECT, screen_x, screen_y, screen_x, screen_y );
	text_mode(0);
	set_trig();

	LOCK_VARIABLE( speed_counter );
	LOCK_FUNCTION( (void *)inc_speed_counter );
	install_int_ex( inc_speed_counter, MSEC_TO_TIMER( 30 ) );

}

int main(){
	init();
	work = create_bitmap( screen_x, screen_y );
	clear( work );
	WormHole wole;
	int timex = 120;
	speed_counter = 30;
	while ( !key[KEY_ESC] ){

		bool yes = false;
		while ( speed_counter > 0 ){
		
			wole.Update();
			speed_counter--;
			yes = true;
		}

	
		if ( yes ){
			wole.Draw();

			if ( timex ){
				int col = timex;
				if ( col > 10 ) col = 10;
				if ( col < 0 ) col = 0;
				textprintf(work,font,1,1, makecol(25*col,25*col,25*col),"Made by Jon Rafkind");
				textprintf(work,font,1,10, makecol(25*col,25*col,25*col), "Email: workmin@ccs.neu.edu" );
				timex--;
			}
			blit( work, screen, 0, 0, 0, 0, 640, 480 );
			clear( work );
		}

	} 
}
END_OF_MAIN();

