/*TODO: Get proper timing working. Fix credits() as noted.*/

/*This is a simple 2-d game in which you fly a plane that is seen from the
side.
Design goals:
*Produce a program that is functional.
*Produce a program that is fun to play.

This game is made with the help of the Allegro Game Programming Library,
without which I would have to write my own graphics code. Thanks to Shawn
Hargreaves for the aforementioned library.
*/

#define WIN32_LEAN_AND_MEAN
#define ALLEGRO_STATICLINK
#include "allegro.h"
#include "spp.h"
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#define LEFT 1
#define RIGHT 2
#define UP 3
#define DOWN 4
#define BACKGROUND_LENGTH 3217

//control styles
#define THROTTLE 1
#define DIRECT 2

//these palette indexes are used for the
//simple "particles" system used in the explosion of
//the enemy plane.
#define YELLOW 219
#define RED 220
#define BLUE 221
#define BLACK 1
#define WHITE 242

void game();
void init();
void title();
void menu();
void save();
void load();
void update_enemy();
void player_crash();
void enemy_crash();
void credits();
void clean_up();

BITMAP* plane_right;
BITMAP* plane_left;
BITMAP* shot;
BITMAP* buffer;
BITMAP* background;
BITMAP* sky;
BITMAP* enemy_left;
BITMAP* enemy_right;
BITMAP* enemy_right;
BITMAP* enemy_left;
BITMAP* eshot;
SAMPLE* crash_sound;

PALETTE palette;

int sky_x = 0, sky_dest_x = 0, bg_x = 0;
int split = 1; //where the "seam" in the sky background is
int enemy_firing = 0;
int is_up_to_date = 0, frame_counter, prev_frame_counter, game_cycle = 0;

int player_energy = 100, enemy_energy = 100;

int done = 0,
		   gamedone = 0,
		   enemy_wins = 0,
		   player_wins = 0,
		   enemy_shot_x = 0,
		   enemy_shot_y = 0,
		   firing = 0;
int x = 320,
		y = 200,
		enemy_x = 500,
		enemy_y = 0,
		last_direction = 2,
		shot_x = 0,
		enemy_last_direction = 1;
int movement_direction = 100;
int velocity = 0; //left is negative, right is positive, 0 is at rest
char control_style = DIRECT; //used to hold a value indicating direct or throttle-style controls

char fps_on = 0; //if this is set to 1, display the FPS on-screen

#include "callback.h"

int main(void)
{
	LOCK_VARIABLE(frame_counter);
	LOCK_VARIABLE(prev_frame_counter);
	LOCK_VARIABLE(is_up_to_date);
	LOCK_FUNCTION(record_fps);

	while (!done)
	{
		init(); //init allegro, the gfx mode, joystick/keyboard support
		title(); //display the title screen
		menu(); //open a menu with options such as new game, save/load, quit
	}
	clean_up();
	return(0);
}
END_OF_MAIN();

void init()
/*This function initializes the allegro library, graphics in 640x480,
joystick routines, sound routines, and keyboard routines.*/
{
	srand((unsigned) time(NULL));
	allegro_init();
	install_timer();
	initialise_joystick();
	if (install_keyboard())
	{
		allegro_message("Cannot initialize keyboard.");
		exit(1);
	}
	reserve_voices(1, 1);
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0);
	set_volume(255, 255);
	set_color_depth(8);
	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
	srand(time(NULL));
}

void title()
/*This displays the title screen in 640x480x256 and waits for the user to
press a key*/
{
	BITMAP* title;
	PALETTE palette;
	title = load_bitmap("title.bmp", palette);
	set_palette(palette);

	blit(title, screen, 0, 0, 0, 0, 640, 480);

	while (!readkey())
	{
	} //loop until the user presses a key
	while (keypressed())
	{
	} //loop until the user releases the key
}

void menu()
/*This displays a graphical menu with the following options:
The user will be referred to game(), credits(), or exited to the OS.
*/
{
	int selected = 1; //the selected menu item
	BITMAP* menu;
	BITMAP* buffer;
	BITMAP* selector;
	BITMAP* menubar;
	MIDI* title;
	SAMPLE* menuopen;
	PALETTE palette;

	buffer = create_bitmap(640, 480);
	menubar = load_bitmap("menubar.bmp", palette);
	selector = load_bitmap("selector.bmp", palette);
	menu = load_bitmap("menu.bmp", palette);
	set_palette(palette);

	menuopen = load_sample("menuopen.wav");
	title = load_midi("title.mid");

	play_sample(menuopen, 255, 128, 1000, 0);

	install_int((void *) time_menuopen, 4);
	while (stretchblit_counter < 480) //make the menubar stretch to fill the screen at a timed rate
	{
		clear(buffer);
		stretch_blit(menubar,
					 buffer,
					 0,
					 0,
					 200,
					 480,
					 0,
					 240 - (stretchblit_counter / 2),
					 200,
					 stretchblit_counter);
		blit(buffer, screen, 0, 0, 0, 0, 640, 480);
		vsync();
	}
	remove_int((void *) time_menuopen);

	rest(500);

	play_midi(title, FALSE);

	while (1)
	{
		blit(menu, buffer, 0, 0, 0, 0, 640, 480);
		masked_blit(menubar, buffer, 0, 0, 0, 0, 640, 480);

		if (selected == 1)
			draw_sprite(buffer, selector, 55, 145);
		if (selected == 2)
			draw_sprite(buffer, selector, 55, 231);
		if (selected == 3)
			draw_sprite(buffer, selector, 55, 319);

		if (key[KEY_ESC])
		{
			clean_up();
			exit(0);
		}

		if (key[KEY_ENTER])
		{
			switch (selected)
			{
			  case 1:
				clear(screen);
				clear(buffer);
				game();
				break;
			  case 2:
				credits();
				break;
			  case 3:
				clean_up();
				exit(0);
			}
		}

		blit(buffer, screen, 0, 0, 0, 0, 640, 480);

		if (key[KEY_UP])
		{
			if (selected > 1)
				selected--;
			rest(200);
		}
		if (key[KEY_DOWN])
		{
			if (selected < 3)
				selected++;
			rest(200);
		}
	}
}

void game()
{
	int slowing_to_a_stop = FALSE;
	gamedone = 0;
	control_style = DIRECT;

	install_int((void *) record_fps, 1000); //set up the timer callback to be called every second

	plane_right = load_bitmap("plane.bmp", palette);
	plane_left = load_bitmap("plane2.bmp", palette);
	shot = load_bitmap("shot.bmp", palette);
	background = load_bitmap("back.bmp", palette);
	sky = load_bitmap("sky.bmp", palette);
	buffer = create_bitmap(640, 480);
	enemy_right = load_bitmap("enemy.bmp", palette);
	enemy_left = load_bitmap("enemy2.bmp", palette);
	eshot = load_bitmap("eshot.bmp", palette);

	crash_sound = load_sample("crash.wav");

	play_midi(NULL, FALSE); //stop the title midi!
	play_midi(load_midi("inflight.mid"), TRUE); //play the game midi

	set_palette(palette);

	while (!gamedone)
	{
		game_cycle++;

		//if(prev_frame_counter>50)
		//	blit(buffer, screen, 0, 0, 0, 0, 640, 480);

		rest((prev_frame_counter + 10) / 2); //slow the game down if it's going too fast	


		if (1) //if we're up to date, draw a frame of graphics
		{
			frame_counter++;
			if (player_energy <= 0)
				player_crash();
			if (enemy_energy <= 0)
				enemy_crash();
			blit(sky, buffer, 0, 0, split, 0, 640, 480);
			if (split > 1)
				blit(sky, buffer, 0, 0, split - 640, 0, 640, 480);

			if (bg_x < -1260)
			{
				bg_x = 1260;
				velocity = 0;
			}

			if (bg_x > -20)
			{
				bg_x = -20;
				velocity = 0;
			}

			draw_sprite(buffer, background, bg_x, 0);

			rect(buffer, 0, 7, 100, 14, YELLOW);
			rectfill(buffer, 0, 7, player_energy, 14, YELLOW);

			rect(buffer, 640, 7, 540, 14, RED);
			rectfill(buffer, 640, 7, 640 - enemy_energy, 14, RED);

			if (control_style == THROTTLE) //display a throttle indicator if appropriate
			{
				rect(buffer, 320, 470, 2, 480, RED);
				rect(buffer, 320, 470, 638, 480, BLUE);
				if (velocity < 0)
					rectfill(buffer,
							 319,
							 470,
							 320 + (int) (velocity * 10.8),
							 480,
							 RED);
				if (velocity >= 0)
					rectfill(buffer,
							 320,
							 470,
							 320 + (int) (velocity * 10.8),
							 480,
							 BLUE);
			}

			split++;

			if (split > 640)
				split = 1;

			//if the player is off the screen and at the end of the background, smoothly bounce him back on
			if (x > 528 && bg_x <= -615)
			{
				x -= 3;
				if (velocity > 0)
					velocity = 0;
			}
			if (x<0 && bg_x> - 4)
			{
				x += 3;
				if (velocity < 0)
					velocity = 0;
			}

			//scroll the background and sky if player moves to edge of screen
			if (x < 0)
			{
				if (bg_x <= 0)
				{
					bg_x -= velocity;
					sky_x -= velocity;
					enemy_x += velocity;
				}

				x = 0;
			}

			if (x > 538)
			{
				sky_x += 3;
				if (bg_x > -627)
				{
					sky_x -= velocity;
					bg_x -= velocity;
					enemy_x -= velocity;
				}

				x = 538;
			}

			update_enemy();

			//draw the plane to the screen facing the correct direction
			if (last_direction == RIGHT)
				draw_sprite(buffer, plane_right, x, y);
			if (last_direction == LEFT)
				draw_sprite(buffer, plane_left, x, y);

			if (key[KEY_C]) //toggle the control style
			{
				if (control_style == THROTTLE)
					control_style = DIRECT;
				else
					control_style = THROTTLE;
				while (key[KEY_C])
				{
				}
			}

			if (key[KEY_F]) //toggle the FPS indicator
			{
				if (fps_on)
					fps_on = 0;
				else
					fps_on = 1;
				while (key[KEY_F])
				{
				}
			}

			textprintf(buffer,
					   font,
					   0,
					   0,
					   RED,
					   "Wins: %i                                                              Losses: %i    ",
					   player_wins,
					   enemy_wins);

			if (fps_on) //display the frame rate if the user has pressed the F key
				textprintf(buffer, font, 0, 18, RED, "%i", prev_frame_counter);

			if (firing)
			{
				if (firing == RIGHT)
				{
					if (shot_x < 700)
					{
						draw_sprite(buffer, shot, shot_x, y);
						shot_x += 14;
						if (spp_detect_collision(enemy_x,
												 enemy_y,
												 enemy_right,
												 shot_x,
												 y,
												 shot))
						{
							enemy_energy -= 10;
							firing = 0;
						}
					}
					else
						firing = 0;
				}
				if (firing == LEFT)
				{
					if (shot_x > -10)
					{
						if (spp_detect_collision(enemy_x,
												 enemy_y,
												 enemy_right,
												 shot_x,
												 y,
												 shot))
						{
							enemy_energy -= 10;
							firing = 0;
						}
						draw_sprite(buffer, shot, shot_x, y);
						shot_x -= 14;
					}
					else
						firing = 0;
				}
			}
			else
				shot_x = x + 50;

			//if the enemy hits the player with a shot, lower the player's energy
			if (spp_detect_collision(x,
									 y,
									 plane_left,
									 enemy_shot_x,
									 enemy_shot_y,
									 eshot) ||
				spp_detect_collision(x,
									 y,
									 plane_right,
									 enemy_shot_x,
									 enemy_shot_y,
									 eshot))
			{
				player_energy -= 10;
				enemy_firing = 0;
			}

			blit(buffer, screen, 0, 0, 0, 0, 640, 480); //blit the buffer to the screen
		}

		if (key[KEY_ESC])
			gamedone = 1;
		if (key[KEY_UP])
			y -= 5;
		if (key[KEY_DOWN])
			y += 5;

		if (key[KEY_RIGHT])
			last_direction = RIGHT;
		if (key[KEY_LEFT])
			last_direction = LEFT;

		//increase our velocity as the player presses the key
		if (key[KEY_RIGHT] && velocity < 30)
			velocity += 1;
		if (key[KEY_LEFT] && velocity > -30)
			velocity -= 1;

		//stop if the user presses the control key
		if (key_shifts & KB_CTRL_FLAG)
			slowing_to_a_stop = TRUE;

		if (slowing_to_a_stop == TRUE)
		{
			if (velocity > 0)
				velocity--;
			if (velocity < 0)
				velocity++;
			if (velocity == 0)
				slowing_to_a_stop = FALSE;
		}

		if (control_style == DIRECT)
		{
			//slow down the plane if a key is not being pressed
			if (!key[KEY_RIGHT] && !key[KEY_LEFT] && velocity > 0)
				velocity -= 1;
			if (!key[KEY_RIGHT] && !key[KEY_LEFT] && velocity < 0)
				velocity += 1;
		}
		x = x + velocity;

		if (key[KEY_SPACE] && last_direction == RIGHT)
			firing = RIGHT;
		if (key[KEY_SPACE] && last_direction == LEFT)
			firing = LEFT;
	}
	shot = load_bitmap("menubar.bmp", palette); //fix the palette so the menu looks right
	play_midi(NULL, FALSE); //stop the theme midi
	play_midi(load_midi("title.mid"), TRUE); //start the title midi
	set_palette(palette);
	remove_int((void *) record_fps); //remove the timer callback
	while (key[KEY_ESC])
	{
	}
}

void update_enemy()
{
	if (enemy_x > 523)
		enemy_x = 523;
	if (enemy_x < 0)
		enemy_x = 0;
	if (enemy_y < y && !firing && enemy_y <= 400) //follow the player up and down
		enemy_y += 5;
	if (enemy_y > y && !firing && enemy_y >= 2)
		enemy_y -= 5;

	if (enemy_y >= y - 40 && enemy_y <= y + 40 && enemy_firing == 0) //if conditions are right, fire
	{
		enemy_firing = enemy_last_direction;
		enemy_shot_y = enemy_y;
		if (enemy_firing == RIGHT)
			enemy_shot_x = enemy_x;
		else
			enemy_shot_x = enemy_x + 112; //112 is the length of the plane

	}

	if (enemy_y < y - 10 &&
		enemy_y >= 10 &&
		enemy_last_direction != firing &&
		firing != 0) //evade incoming shots
		enemy_y -= 10;
	if (enemy_y > y - 10 &&
		enemy_y <= 400 &&
		enemy_last_direction != firing &&
		firing != 0)
		enemy_y += 10;

	if (x > enemy_x + 117) //117 is the length of the plane
		enemy_last_direction = RIGHT; //turn around to face the player

	if (x < enemy_x)
		enemy_last_direction = LEFT;

	if (x > enemy_x + 300) //make the enemy catch up with the player if need be
		enemy_x += 5;
	if (enemy_x > x + 300)
		enemy_x -= 5;

	if (enemy_firing)
	{
		if (enemy_firing == RIGHT)
		{
			if (enemy_shot_x <= 800)
			{
				draw_sprite(buffer, eshot, enemy_shot_x, enemy_shot_y);
				enemy_shot_x += 14;
			}
			else
				enemy_firing = 0;
		}

		if (enemy_firing == LEFT)
		{
			if (enemy_shot_x > -10)
			{
				draw_sprite(buffer, eshot, enemy_shot_x, enemy_shot_y);
				enemy_shot_x -= 14;
			}
			else
				enemy_firing = 0;
		}
	}
	else
		enemy_shot_x = enemy_x + 50;

	if (enemy_last_direction == RIGHT)
		draw_sprite(buffer, enemy_right, enemy_x, enemy_y);
	if (enemy_last_direction == LEFT)
		draw_sprite(buffer, enemy_left, enemy_x, enemy_y);
}

void player_crash()
{
	BITMAP* particle_layer = create_bitmap(640, 480);
	BITMAP* nuke = load_bitmap("nuke.bmp", palette);
	int crash_counter = 0, temp = 0;

	struct point
	{
		int px;
		int py;
		int color;
	} crash_particle[300];

	midi_pause();
	clear(particle_layer);
	play_sample(crash_sound, 255, 128, 1000, 0);

	while (crash_counter < 300) //init all the points
	{
		temp = rand() % 13;
		if (temp < 3)
			crash_particle[crash_counter].color = BLUE;
		else if (temp >= 3 && temp < 5)
			crash_particle[crash_counter].color = WHITE;
		else if (temp > 5 && temp < 7)
			crash_particle[crash_counter].color = YELLOW;
		else if (temp >= 7 && temp < 10)
			crash_particle[crash_counter].color = RED;
		else
			crash_particle[crash_counter].color = BLACK;

		crash_particle[crash_counter].px = x + 58 + ((rand() % 10) - 5); //each particle starts in the center of the plane
		crash_particle[crash_counter].py = y + 19 + ((rand() % 10) - 5);
		crash_counter++;
	}

	iteration_counter = 0;

	install_int((void *) time_explosion, 45); //make sure the explosion is timed properly
	while (iteration_counter <= 100)
	{
		blit(sky, buffer, 0, 0, split, 0, 640, 480);
		if (split > 1)
			blit(sky, buffer, 0, 0, split - 640, 0, 640, 480);

		draw_sprite(buffer, background, bg_x, 0);
		update_enemy(); //make sure the enemy is still on-screen during the crash sequence

		crash_counter = 0;

		while (crash_counter < 300) //render all the particles
		{
			//make particles fan out
			crash_particle[crash_counter].px += ((crash_counter / 10) -
												 (rand() % 15)) /
												2;

			crash_particle[crash_counter].py = crash_particle[crash_counter].py +
											   ((rand() % 10) - 3);

			putpixel(particle_layer,
					 crash_particle[crash_counter].px,
					 crash_particle[crash_counter].py,
					 crash_particle[crash_counter].color);
			crash_counter++;
		}

		//draw the nuclear shockwave, which is timed to be the same duration on all systems
		masked_stretch_blit(nuke,
							particle_layer,
							0,
							0,
							680,
							240,
							x + 56 - ((iteration_counter * 35) / 2),
							y + 18 - (int) ((iteration_counter * 4.8) / 2),
							iteration_counter * 35,
							(int) (iteration_counter * 4.8));

		masked_blit(particle_layer, buffer, 0, 0, 0, 0, 640, 480);

		if (iteration_counter <= 7) //make the screen flash
			clear_to_color(screen, WHITE);
		else
			blit(buffer, screen, 0, 0, 0, 0, 640, 480);
		clear(particle_layer);
	}
	remove_int((void *) time_menuopen);

	enemy_wins++;

	player_energy = 100;
	velocity = 0;
	midi_resume();
	destroy_bitmap(particle_layer);
	destroy_bitmap(nuke);
}

void enemy_crash()
{
	BITMAP* particle_layer = create_bitmap(640, 480);
	int crash_counter = 0, iteration_counter = 0,temp = 0;

	struct point
	{
		int px;
		int py;
		int color;
	} crash_particle[300];

	midi_pause();
	clear(particle_layer);
	play_sample(crash_sound, 255, 128, 1000, 0);

	while (crash_counter < 300) //init all the points
	{
		temp = rand() % 10;
		if (temp < 3)
			crash_particle[crash_counter].color = BLUE;
		if (temp >= 3 && temp < 5)
			crash_particle[crash_counter].color = WHITE;
		if (temp > 5 && temp < 7)
			crash_particle[crash_counter].color = YELLOW;
		if (temp >= 7)
			crash_particle[crash_counter].color = RED;

		crash_particle[crash_counter].px = enemy_x + 58 + ((rand() % 10) - 5); //each particle starts in the center of the plane
		crash_particle[crash_counter].py = enemy_y + 19 + ((rand() % 10) - 5);
		crash_counter++;
	}


	while (iteration_counter <= 50)
	{
		blit(sky, buffer, 0, 0, split, 0, 640, 480);
		if (split > 1)
			blit(sky, buffer, 0, 0, split - 640, 0, 640, 480);

		//make sure the player is still on-screen during the crash sequence
		draw_sprite(buffer, background, bg_x, 0);
		if (last_direction == RIGHT)
			draw_sprite(buffer, plane_right, x, y);
		if (last_direction == LEFT)
			draw_sprite(buffer, plane_left, x, y);

		crash_counter = 0;

		while (crash_counter < 300) //render all the particles
		{
			//make particles fan out
			crash_particle[crash_counter].px += ((crash_counter / 10) -
												 (rand() % 15)) /
												2;

			crash_particle[crash_counter].py += ((rand() % 20) - 3);

			putpixel(particle_layer,
					 crash_particle[crash_counter].px,
					 crash_particle[crash_counter].py,
					 crash_particle[crash_counter].color);
			crash_counter++;
		}

		masked_blit(particle_layer, buffer, 0, 0, 0, 0, 640, 480);
		blit(buffer, screen, 0, 0, 0, 0, 640, 480);
		clear(particle_layer);
		iteration_counter++;
	}
	player_wins++;
	enemy_x = x + 250;
	enemy_y = y - 150;
	if (enemy_x < 0)
		enemy_x = 0;
	if (enemy_x > 528)
		enemy_x = 528;
	if (enemy_y < 0)
		enemy_y = 0;
	if (enemy_y > 402)
		enemy_y = 402;
	enemy_energy = 100;
	velocity = 0;

	destroy_bitmap(particle_layer);
	midi_resume();
}

void credits()
{
	BITMAP* stormy;
	BITMAP* stormy2;
	BITMAP* stormy3;
	BITMAP* stormy4;
	PALETTE palette;
	PALETTE previous_palette;
	SAMPLE* thunder;
	BITMAP* buffer = create_bitmap(640, 480);
	unsigned int counter = 0,counter2 = 0;

	get_palette(previous_palette);

	thunder = load_sample("thunder.wav");
	stormy = load_bitmap("credits/sky-stormy.bmp", palette);
	stormy2 = load_bitmap("credits/sky-stormy2.bmp", palette);
	stormy3 = load_bitmap("credits/sky-stormy3.bmp", palette);
	stormy4 = load_bitmap("credits/sky-stormy4.bmp", palette);
	set_palette(palette);

	play_midi(NULL, FALSE); //stop the title midi

	credits_counter = 0;

	install_int((void *) time_credits, 50);
	while (!key[KEY_ESC])
	{
		blit(stormy, buffer, 0, 0, 0, 0, 640, 480);
		blit(buffer, screen, 0, 0, 0, 0, 640, 480);
		if (credits_counter == 500 ||
			credits_counter == 1500 ||
			credits_counter == 3000 ||
			credits_counter == 6000 ||
			credits_counter == 9000 ||
			credits_counter == 12000 ||
			credits_counter == 15000 ||
			credits_counter == 21000 ||
			credits_counter == 36000 ||
			credits_counter == 45000 ||
			credits_counter == 54000 ||
			credits_counter == 63000)
		{
			play_sample(thunder, 255, 128, 1000, 0);

			while (counter2 <= 10 && !key[KEY_ESC])
			{
				blit(stormy2, buffer, 0, 0, 0, 0, 640, 480);
				counter2++;
				blit(buffer, screen, 0, 0, 0, 0, 640, 480);
			}

			while (counter2 <= 30 && !key[KEY_ESC])
			{
				blit(stormy3, buffer, 0, 0, 0, 0, 640, 480);
				counter2++;
				blit(buffer, screen, 0, 0, 0, 0, 640, 480);
			}

			while (counter2 <= 35 && !key[KEY_ESC])
			{
				blit(stormy2, buffer, 0, 0, 0, 0, 640, 480);
				counter2++;
				blit(buffer, screen, 0, 0, 0, 0, 640, 480);
			}

			while (counter2 <= 40 && !key[KEY_ESC])
			{
				blit(stormy, buffer, 0, 0, 0, 0, 640, 480);
				counter2++;
				blit(buffer, screen, 0, 0, 0, 0, 640, 480);
			}

			while (counter2 <= 50 && !key[KEY_ESC])
			{
				blit(stormy2, buffer, 0, 0, 0, 0, 640, 480);
				counter2++;
				blit(buffer, screen, 0, 0, 0, 0, 640, 480);
			}   			  

			while (counter2 <= 52 && !key[KEY_ESC])
			{
				blit(stormy4, buffer, 0, 0, 0, 0, 640, 480);
				counter2++;
				blit(buffer, screen, 0, 0, 0, 0, 640, 480);
			}   			  

			counter2 = 0;
		}
		if (credits_counter > 63000)
			credits_counter = 0;
	}
	remove_int((void *) time_credits);
	set_palette(previous_palette); //restore the original palette

	while (key[KEY_ESC])
	{
	}

	destroy_sample(thunder);
	destroy_bitmap(stormy);
	destroy_bitmap(stormy2);
	destroy_bitmap(stormy3);
	destroy_bitmap(stormy4);
}

void clean_up()
{
	destroy_bitmap(plane_right);
	destroy_bitmap(plane_left);
	destroy_bitmap(shot);
	destroy_bitmap(buffer);
	destroy_bitmap(background);
	destroy_bitmap(sky);
	destroy_bitmap(enemy_left);
	destroy_bitmap(enemy_right);
	destroy_bitmap(enemy_right);
	destroy_bitmap(enemy_left);
	destroy_bitmap(eshot);
	destroy_sample(crash_sound);
	destroy_bitmap(buffer);
}
