#include "unborn.h"
#include "menuitem.h"
#include "menuitemtoggle.h"
#include "menuitemslider.h"
#include "menuitemedit.h"
#include "data.h"
#include "highscore.h"
#include <jpgalleg.h>
#include <list>
using namespace std;

static int song = 2;

UnbornGame::UnbornGame() : Game(), dplayer(NULL), volume(1.0f) {
	usprintf(gameTitle, "Unborn");
	
	int y = 64;
	int dy = 22;
	mainMenu.AddItem(new MenuItem("Play Game", NEW_GAME, y+=dy));
	mainMenu.AddItem(new MenuItem("Options", DOING_OPTIONS_MENU, y+=dy));
	mainMenu.AddItem(new MenuItem("High Scores", DOING_HISCORE_MENU2, y+=dy));
	//mainMenu.AddItem(new MenuItem("Help", DOING_HELP_MENU, y+=dy));
	mainMenu.AddItem(new MenuItem("Story", DOING_STORY_MENU, y+=dy));
	mainMenu.AddItem(new MenuItem("Credits", DOING_CREDITS_MENU, y+=dy));
	mainMenu.AddItem(new MenuItem("Exit", DOING_YESNO_MENU2, y+=dy));
	
	y = 64;
	dy = 16;
	static int oParticles[] = { 0, 20, 40, 60 };
	static char *onParticles[] = { "none", "few", "some", "a lot" };
	static int oStars[] = { 0, 100, 300, 600 };
	static char *onStars[] = { "none", "few", "some", "a lot" };
	static int oDifficulty[] = { 0, 1, 2 };
	static char *onDifficulty[] = { "easy", "normal", "hard" };
	static int oVolume[] = { 0,25,50,75,100,125,150,175,200,225,250 };
	static char *onVolume[] = {
		"[__________|",
		"[_________|",
		"[________|",
		"[_______|",
		"[______|",
		"[_____|",
		"[____|",
		"[___|",
		"[__|",
		"[_|",
		"[|"
	};
	optionsMenu.AddItem(new MenuItemToggle("Use vsync", DOING_OPTIONS_MENU, y+=dy, &Params::vsync));
	optionsMenu.AddItem(new MenuItemToggle("Unlimited FPS", DOING_OPTIONS_MENU, y+=dy, &Params::unlimitedFPS));
	optionsMenu.AddItem(new MenuItemToggle("Show FPS", DOING_OPTIONS_MENU, y+=dy, &Params::showFPS));
	optionsMenu.AddItem(new MenuItemToggle("Yield timeslice", DOING_OPTIONS_MENU, y+=dy, &Params::yield));
	optionsMenu.AddItem(new MenuItemSlider("Particles", DOING_OPTIONS_MENU, y+=dy, &Params::maxParticles, 4, oParticles, onParticles));
	optionsMenu.AddItem(new MenuItemSlider("Stars", DOING_OPTIONS_MENU, y+=dy, &Params::nStars, 4, oStars, onStars));
	optionsMenu.AddItem(new MenuItemSlider("Difficulty", DOING_OPTIONS_MENU, y+=dy, &Params::difficulty, 3, oDifficulty, onDifficulty));
	optionsMenu.AddItem(new MenuItemSlider("Sound", DOING_OPTIONS_MENU, y+=dy, &Params::volSound, 11, oVolume, onVolume));
	optionsMenu.AddItem(new MenuItemSlider("Music", DOING_OPTIONS_MENU, y+=dy, &Params::volMusic, 11, oVolume, onVolume));

	hscMenu.AddItem(new MenuItem("Back", DOING_MAIN_MENU, 64));


	y = 72;
	dy = 22;
	MenuItem *item;
	item = new MenuItem("Congratulations!", DOING_HISCORE_MENU, y+=dy);			item->Disable();	hscMenu2.AddItem(item);
	item = new MenuItem("You have a high score!", DOING_HISCORE_MENU, y+=dy);	item->Disable();	hscMenu2.AddItem(item);
	item = new MenuItem("Please enter your name", DOING_HISCORE_MENU, y+=dy);	item->Disable();	hscMenu2.AddItem(item);
	hscMenu2.AddItem(new MenuItemEdit("        ", DOING_HISCORE_MENU2, y+=dy));

	y = 56;
	dy = 16;
	item = new MenuItem("the UNBORN", DOING_CREDITS_MENU, y+=dy);									item->Disable();	creditsMenu.AddItem(item);
	item = new MenuItem("a 2003 HalloweenHack game", DOING_CREDITS_MENU, y+=dy);				item->Disable();	creditsMenu.AddItem(item);
	item = new MenuItem("code, gfx and music by", DOING_CREDITS_MENU, y+=3*dy/2);				item->Disable();	creditsMenu.AddItem(item);
	item = new MenuItem("Miran Amon", DOING_CREDITS_MENU, y+=dy);								item->Disable();	creditsMenu.AddItem(item);
	item = new MenuItem("this game was written with the Allegro", DOING_CREDITS_MENU, y+=3*dy/2);item->Disable();	creditsMenu.AddItem(item);
	item = new MenuItem("game programming library", DOING_CREDITS_MENU, y+=dy);item->Disable();	creditsMenu.AddItem(item);
	item = new MenuItem("copyright (c) 2003 by Miran Amon", DOING_CREDITS_MENU, y+=3*dy/2);		item->Disable();	creditsMenu.AddItem(item);
	creditsMenu.AddItem(new MenuItem("Back", DOING_MAIN_MENU, y+=3*dy/2));
	
	mainMenu.previousState = DOING_YESNO_MENU2;
	optionsMenu.previousState = DOING_MAIN_MENU;
	hscMenu.previousState = DOING_MAIN_MENU;
	hscMenu2.previousState = DOING_HISCORE_MENU2;
	creditsMenu.previousState = DOING_MAIN_MENU;
	theGame.previousState = DOING_MAIN_MENU;
	story.previousState = DOING_MAIN_MENU;

	yesnoMenu1.previousState = PLAYING_GAME;
	yesnoMenu2.previousState = QUIT_PROGRAM;
	yesnoMenu1.Setup("Are you sure you want to quit?", "Yes / No", KEY_Y, KEY_N, DOING_MAIN_MENU, PLAYING_GAME);
	yesnoMenu2.Setup("Are you sure you want to quit?", "Yes / No", KEY_Y, KEY_N, QUIT_PROGRAM, DOING_MAIN_MENU);
	
	SwitchToScreen(&mainMenu);
}


UnbornGame::~UnbornGame() {
	TRACE("UnbornGame::~UnbornGame()\n");
	Data::Unload();
	dplayer = NULL;
}


Error UnbornGame::Init() {
	Error e;
	
	if (e = Game::Init()) return e;
	jpgalleg_init();
	atexit(&dumb_exit);
	dumb_register_stdfiles();
	
	if (e = mainMenu.Init()) return e;
	if (e = optionsMenu.Init()) return e;
	if (e = hscMenu.Init()) return e;
	if (e = creditsMenu.Init()) return e;
	if (e = story.Init()) return e;
	if (e = theGame.Init()) return e;
	if (!Data::Load()) return Error(Error::DATA);

	DUH_SIGRENDERER *sr = dumb_it_start_at_order(Data::music, 2, 15);
	volume = (float)Params::volMusic/256.0f;
	dplayer = al_duh_encapsulate_sigrenderer(sr, volume, 8192, 44100);
	
	return e;
}


bool UnbornGame::Update() {
	Game::Update();
	
	volume = (float)Params::volMusic/256.0f;
	if (dplayer) {
		al_duh_set_volume(dplayer, volume);
	}
	al_poll_duh(dplayer);
	
	if (currentScreen->Update()) {
		switch (currentScreen->NextState()) {
			case QUIT_PROGRAM:
				return true;
			
			case NEW_GAME: {
				theGame.Init();
				al_stop_duh(dplayer);
				DUH_SIGRENDERER *sr = dumb_it_start_at_order(Data::music, 2, 0);
				dplayer = al_duh_encapsulate_sigrenderer(sr, volume, 8192, 44100);
				song = 0;
			}
				// fall through
			
			case PLAYING_GAME:
				SwitchToScreen(&theGame);
				break;
			
			case PLAYING_GAME_OVER: {
				al_stop_duh(dplayer);
				DUH_SIGRENDERER *sr = dumb_it_start_at_order(Data::music, 2, 12);
				dplayer = al_duh_encapsulate_sigrenderer(sr, volume, 8192, 44100);
				song = 1;
			}
				break;
			
			case DOING_MAIN_MENU: {
				if (song != 2) {
					al_stop_duh(dplayer);
					DUH_SIGRENDERER *sr = dumb_it_start_at_order(Data::music, 2, 15);
					dplayer = al_duh_encapsulate_sigrenderer(sr, volume, 8192, 44100);
					song = 2;
				}
				SwitchToScreen(&mainMenu);
			}
				break;
			
			case DOING_OPTIONS_MENU:
				SwitchToScreen(&optionsMenu);
				break;
			
			case DOING_HISCORE_MENU:
				hscMenu2.Init();
				SwitchToScreen(&hscMenu2);
				break;
			
			case DOING_HISCORE_MENU2:
				hscMenu.previousState = DOING_HISCORE_MENU2;
				FillHscMenu();
				hscMenu.previousState = DOING_MAIN_MENU;
				SwitchToScreen(&hscMenu);
				break;
			
			case DOING_STORY_MENU:
				story.Init();
				SwitchToScreen(&story);
				break;

			case DOING_CREDITS_MENU:
				creditsMenu.Init();
				SwitchToScreen(&creditsMenu);
				break;

			case DOING_YESNO_MENU:
				SwitchToScreen(&yesnoMenu1);
				break;

			case DOING_YESNO_MENU2:
				SwitchToScreen(&yesnoMenu2);
				break;
		};
	}
	
	return false;
}


void UnbornGame::Draw(BITMAP *canvas) {
	currentScreen->Draw(canvas);
	Game::Draw(canvas);
}


void UnbornGame::SwitchToScreen(GameScreen *screen) {
	currentScreen = screen;
	currentScreen->ResetInputState();
}


void UnbornGame::FillHscMenu() {
	Highscore hsc("unborn.hsc");
	
	if (currentScreen == &hscMenu2) {
		char *name = hscMenu2.GetSelectedItem()->GetText();
		int score = theGame.score.Get();
		hsc.Add(name, score);
	}
	
	list<HighscoreItem *> items = hsc.GetTable();
	int y = 56;
	int dy = 16;
	char buf[32];
	hscMenu.Clear();
	for (list<HighscoreItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		usprintf(buf, "%s ...... %08d", (*i)->name, (*i)->score);
		MenuItem *item = new MenuItem(buf, hscMenu.previousState, y+=dy);
		item->Disable();
		hscMenu.AddItem(item);
	}
	hscMenu.AddItem(new MenuItem("Back", DOING_MAIN_MENU, y+=3*dy/2));
	hscMenu.Init();
}
