#include "score.h"

Score::Score() : value(0), delta(12), addedScore(0) {
}


Score::~Score() {
}


int Score::operator+=(int v) {
	addedScore += v;
	return value + v;
}


int Score::Get() {
	return value + addedScore;
}


int Score::CurrentValue() {
	return value;
}


void Score::Update() {
	if (addedScore > 2400) {
		delta = 256;
	}
	else if (addedScore > 1200) {
		delta = 128;
	}
	else if (addedScore > 600) {
		delta = 64;
	}
	else {
		delta = 16;
	}
	if (addedScore >= delta) {
		value += delta;
		addedScore -= delta;
	}
	else if (addedScore > 0) {
		value += addedScore;
		addedScore = 0;
	}
}


bool Score::Done() {
	return (addedScore == 0);
}


void Score::Reset() {
	value = 0;
	addedScore = 0;
	delta = 0;
}
