#include "prompt.h"
#include "data.h"
#include "../base/params.h"

void Prompt::Draw(BITMAP *canvas) {
	int w = MAX(text_length(font, prompt), text_length(font, options));
	w += 30;
	int th = text_height(font);
	int h = th*7/2;
	int x = (SCREEN_W - w)/2;
	int y = (SCREEN_H - h)/2;

	BITMAP *back = create_bitmap(w, h);
	clear_to_color(back, makecol(32,64,48));
	rect(back, 0, 0, back->w-1, back->h-1, makecol(0,0,0));
	set_trans_blender(0,0,0,32);
	draw_trans_sprite(canvas, back, x, y);
	destroy_bitmap(back);

	textout_centre(canvas, font, prompt, SCREEN_W/2+1, y+1+th/2, makecol(0,0,0));
	textout_centre(canvas, font, prompt, SCREEN_W/2, y+th/2, makecol(190,150,84));
	textout_centre(canvas, font, options, SCREEN_W/2+1, y+1+2*th, makecol(0,0,0));
	textout_centre(canvas, font, options, SCREEN_W/2, y+2*th, makecol(240,220,128));
}


bool Prompt::Update() {
	if (::key[key1] && !key[key1]) {
		ret = next1;
		return true;
	}

	else if (::key[key2] && !key[key2]) {
		ret = next2;
		return true;
	}
	
	else if (::key[KEY_ENTER] && !key[KEY_ENTER]) {
		ret = next1;
		return true;
	}
	
	else {
		ret = next2;
	}
	
	return GameScreen::Update();
}


Prompt::Prompt() : GameScreen(), prompt(NULL), options(NULL), key1(0), key2(0) {
}


Prompt::~Prompt() {
	TRACE("Prompt::~Prompt()\n");

	if (prompt) {
		delete [] prompt;
	}

	if (options) {
		delete [] options;
	}
}


GameState Prompt::NextState() {
	return ret;
}


void Prompt::Setup(const char *prompt, const char *options, char key1, char key2, GameState next1, GameState next2) {
	this->prompt = new char[ustrsizez(prompt)];
	ustrcpy(this->prompt, prompt);
	this->options = new char[ustrsizez(options)];
	ustrcpy(this->options, options);
	this->key1 = key1;
	this->key2 = key2;
	this->next1 = next1;
	this->next2 = next2;
	ret = previousState;
}
