#include "powerup.h"
#include "camera.h"
#include "data.h"
#include "../base/params.h"

Powerup::Powerup(int type) : Player() {
	this->type = type;
	Init();
}


Powerup::~Powerup() {
	TRACE("Powerup::~Powerup()\n");
}


void Powerup::Init() {
	pos.x = (float)(rand()%((int)(max.x - min.x))) + min.x;
	pos.y = (float)(rand()%((int)(max.y - min.y))) + min.y;
	hp = 600;
}


void Powerup::Update() {
	if (state == SPAWNING) {
		if (hp <= 0) {
			--stateCounter;
			if (stateCounter <= 0) {
				state = DEAD;
			}
		}
		else {
			++stateCounter;
			if (stateCounter >= 60) {
				state = ALIVE;
			}
		}
	}
	
	if (state != DYING) {
		if (particles.size() < 15 && particleCounter == 0) {
			particles.push_back(Particle(pos.x, pos.y, (float)(rand()%255-128)/256.0f, (float)(rand()%255-128)/256.0f));
			particleCounter = 3;
		}
	}

	if (particleCounter > 0) {
		--particleCounter;
	}
	
	vector<Particle>::iterator i;
	for (i = particles.begin(); i != particles.end(); ) {
		if (i->life <= 0) {
			i = particles.erase(i);
		}
		else {
			i->Update();
			++i;
		}
	}

	if (state != DEAD) {
		--hp;
		if (hp <= 0) {
			state = SPAWNING;
		}
	}
}


void Powerup::Draw(BITMAP *canvas, Camera *camera) {
	if (state == ALIVE || state == DYING) {
		int s = 6;
		int x = (int)(pos.x - camera->pos.x + camera->min.x) - s;
		int y = (int)(pos.y - camera->pos.y + camera->min.y) - s;
		
		// draw the particles
		vector<Particle>::iterator i;
		for (i = particles.begin(); i != particles.end(); ++i) {
			set_trans_blender(255,255,255, 3*i->trans/4);
			draw_trans_sprite(canvas, Data::powerup[type], (int)(i->x - camera->pos.x + camera->min.x) - s, (int)(i->y - camera->pos.y + camera->min.y) - s);
		}
	}
	else {
		int s = stateCounter*6/60;
		int x = (int)(pos.x - camera->pos.x + camera->min.x);
		int y = (int)(pos.y - camera->pos.y + camera->min.y);

		// draw the particles (tail)
		vector<Particle>::iterator i;
		for (i = particles.begin(); i != particles.end(); ++i) {
			clear_to_color(tmpBmp, makecol(255,0,255));
			stretch_sprite(tmpBmp, Data::powerup[type], 6 - s, 6 - s, s*2, s*2);
			set_trans_blender(255,255,255, 3*i->trans/4);
			draw_trans_sprite(canvas, tmpBmp, (int)(i->x - camera->pos.x + camera->min.x) - 6, (int)(i->y - camera->pos.y + camera->min.y) - 6);
		}
	}
}


void Powerup::Kill() {
	state = Player::DYING;
	hp = 30;

	for (int i=0; i<60; i++) {
		Particle p(pos.x, pos.y, (float)(rand()%255-128)/64.0f, (float)(rand()%255-128)/64.0f);
		p.life = 30;
		particles.push_back(p);
	}
}
