#ifndef		MAINGAME_H
#define		MAINGAME_H

#include "debug.h"
#include "gamescreen.h"
#include "player.h"
#include "camera.h"
#include "star.h"
#include "soul.h"
#include "powerup.h"
#include "scorebubble.h"
#include "score.h"
#include <vector>
using namespace std;

class MainGame : public GameScreen {
	private:
		BITMAP *minimap;
		vector<Star *> star;
		vector<Soul *> soul;
		vector<Powerup *> powerup;
		vector<ScoreBubble *> bubble;
		Player *player;
		Camera *camera;
	
		int spawnCounter;
		int powerupCounter;
		int sampleCounter, delay;
		bool playing;
	
		void SpawnSoul();
		void SpawnPowerup();
		void KillPlayer(Player *p);
		void KillPowerup(Powerup *p);
		bool ValidatePosition(Soul *s);
		void DoCollisionDetection();
		void Collide(Player *o1, Player *o2);
		void DrawMinimap(BITMAP *canvas);
		void DrawHP(BITMAP *canvas);
		void DrawScore(BITMAP *canvas);
		void PlayScream();

	public:
		Score score;

	public:
		MainGame();
		virtual ~MainGame();

		virtual Error Init();
		virtual GameState NextState();
		virtual void Draw(BITMAP *canvas);
		virtual bool Update();
};

#endif		//MAINGAME_H
