#ifndef		HIGHSCORE_H
#define		HIGHSCORE_H

#include <allegro.h>
#include <list>
using namespace std;


class HighscoreItem {
	public:
		HighscoreItem(const char *n, int s);
		~HighscoreItem();
	
		char name[9];
		int score;
};


class Highscore {
	protected:
		list<HighscoreItem *> items;
		int nItems;
		char *fileName;
	
		void MakeDefaultTable();
		void DestroyTable();
		void Load(PACKFILE *f);
		void Save(PACKFILE *f);

	public:
		Highscore(const char *file);
		~Highscore();
	
		bool CanAdd(int score);
		void Add(const char *name, int score);
	
		list<HighscoreItem *>& GetTable();
};

#endif		//HIGHSCORE_H
