#include "data.h"

BITMAP *Data::menuBack = NULL;
BITMAP *Data::space = NULL;
BITMAP *Data::face[16] = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL };
BITMAP *Data::tail[8] = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL };
BITMAP *Data::powerup[7] = { NULL,NULL,NULL,NULL,NULL,NULL,NULL };
DUH *Data::music = NULL;
SAMPLE *Data::amb[4] = { NULL,NULL,NULL,NULL };
SAMPLE *Data::die = NULL;
SAMPLE *Data::thump = NULL;
SAMPLE *Data::collect = NULL;
SAMPLE *Data::select = NULL;
SAMPLE *Data::scream[10] = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL };

bool Data::Load() {
	int i;
	char name[32];
	bool failed = false;
	DATAFILE *d = NULL;

	menuBack = (d = load_datafile_object("data.dat", "BACK")) ? (BITMAP *)(d->dat) : NULL;
	space = (d = load_datafile_object("data.dat", "SPACE")) ? (BITMAP *)(d->dat) : NULL;
	failed = !menuBack || !space;

	for (i=0; i<8; i++) {
		usprintf(name, "FACE%dG", i+1);
		face[i] = (d = load_datafile_object("data.dat", name)) ? (BITMAP *)(d->dat) : NULL;
		if (!face[i]) {
			failed = true;
		}
		usprintf(name, "FACE%dB", i+1);
		face[i+8] = (d = load_datafile_object("data.dat", name)) ? (BITMAP *)(d->dat) : NULL;
		if (!face[i+8]) {
			failed = true;
		}
	}
	for (i=0; i<4; i++) {
		usprintf(name, "TAIL%dG", i+1);
		tail[i] = (d = load_datafile_object("data.dat", name)) ? (BITMAP *)(d->dat) : NULL;
		if (!tail[i]) {
			failed = true;
		}
		usprintf(name, "TAIL%dB", i+1);
		tail[i+4] = (d = load_datafile_object("data.dat", name)) ? (BITMAP *)(d->dat) : NULL;
		if (!tail[i+4]) {
			failed = true;
		}
	}
	for (i=0; i<7; i++) {
		usprintf(name, "STAR%d", i+1);
		powerup[i] = (d = load_datafile_object("data.dat", name)) ? (BITMAP *)(d->dat) : NULL;
		if (!powerup[i]) {
			failed = true;
		}
	}
	
	font = (d = load_datafile_object("data.dat", "FNT1")) ? (FONT *)(d->dat) : NULL;
	
	music = dumb_load_it("unborn.it");
	if (!music) {
		failed = true;
	}

	for (i=0; i<2; i++) {
		usprintf(name, "AMB%d", i+1);
		amb[i] = (d = load_datafile_object("data.dat", name)) ? (SAMPLE *)(d->dat) : NULL;
		if (!amb[i]) {
			failed = true;
		}
		usprintf(name, "AMB%d", i+1);
		amb[i+2] = (d = load_datafile_object("data.dat", name)) ? (SAMPLE *)(d->dat) : NULL;
		if (!amb[i+2]) {
			failed = true;
		}
	}
	die = (d = load_datafile_object("data.dat", "DIE")) ? (SAMPLE *)(d->dat) : NULL;
	thump = (d = load_datafile_object("data.dat", "THUMP")) ? (SAMPLE *)(d->dat) : NULL;
	collect = (d = load_datafile_object("data.dat", "COLLECT")) ? (SAMPLE *)(d->dat) : NULL;
	select = (d = load_datafile_object("data.dat", "SELECT")) ? (SAMPLE *)(d->dat) : NULL;
	for (i=0; i<10; i++) {
		usprintf(name, "SCR%d", i);
		scream[i] = (d = load_datafile_object("data.dat", name)) ? (SAMPLE *)(d->dat) : NULL;
		if (!scream[i]) {
			failed = true;
		}
	}
	
	if (failed) {
		Unload();
	}
	
	return !failed;
}


void Data::Unload() {
	if (menuBack) {
		destroy_bitmap(menuBack);
		menuBack = NULL;
	}
	
	if (space) {
		destroy_bitmap(space);
		space = NULL;
	}
	
	int i;
	for (i=0; i<8; i++) {
		if (face[i]) {
			destroy_bitmap(face[i]);
			face[i] = NULL;
		}
		if (face[i+8]) {
			destroy_bitmap(face[i+8]);
			face[i+8] = NULL;
		}
	}
	for (i=0; i<4; i++) {
		if (tail[i]) {
			destroy_bitmap(tail[i]);
			tail[i] = NULL;
		}
		if (tail[i+4]) {
			destroy_bitmap(tail[i+4]);
			tail[i+4] = NULL;
		}
	}
	for (i=0; i<7; i++) {
		if (powerup[i]) {
			destroy_bitmap(powerup[i]);
			powerup[i] = NULL;
		}
	}
	for (i=0; i<4; i++) {
		if (amb[i]) {
			destroy_sample(amb[i]);
			amb[i] = NULL;
		}
	}
	if (die) {
		destroy_sample(die);
		die = NULL;
	}
	if (thump) {
		destroy_sample(thump);
		thump = NULL;
	}
	if (collect) {
		destroy_sample(collect);
		collect = NULL;
	}
	if (select) {
		destroy_sample(select);
		select = NULL;
	}
	for (i=0; i<10; i++) {
		if (scream[i]) {
			destroy_sample(scream[i]);
			scream[i] = NULL;
		}
	}
	
	if (music) {
		unload_duh(music);
		music = NULL;
	}
}
