#include "aiinput.h"
#include "player.h"


AIInput::AIInput() : player(NULL), parent(NULL), moveLeft(false), moveRight(false), moveUp(false), moveDown(false) {
}


AIInput::~AIInput() {
	TRACE("AIInput::~AIInput()\n");
}


bool AIInput::Left() {
	return moveLeft;
}

bool AIInput::Right() {
	return moveRight;
}

bool AIInput::Up() {
	return moveUp;
}

bool AIInput::Down() {
	return moveDown;
}


void AIInput::Update() {
	float dx = parent->pos.x - player->pos.x;
	float dy = parent->pos.y - player->pos.y;

	if (dx*dx + dy*dy > 40000.0f) {
		if (parent->v.x*dx > 0.0f || parent->v.y*dy > 0.0f) {
			return;
		}
	}

	int q = 0;
	if (dx > 0) {
		q |= 0x01;
	}
	if (dy > 0) {
		q |= 0x02;
	}
	
	switch (q) {
		case 0x00:
			if (dx < 2*dy) {
				moveRight = true;
				moveLeft = moveUp = moveDown = false;
			}
			else if (dy < 2*dx) {
				moveDown = true;
				moveRight = moveLeft = moveUp = false;
			}
			else {
				moveRight = moveDown = true;
				moveUp = moveLeft = false;
			}
			break;
		
		case 0x01:
			if (dx > 2*dy) {
				moveLeft = true;
				moveRight = moveUp = moveDown = false;
			}
			else if (dy < 2*dx) {
				moveDown = true;
				moveRight = moveLeft = moveUp = false;
			}
			else {
				moveDown = moveLeft = true;
				moveRight = moveUp = false;
			}
			break;
		
		case 0x02:
			if (dx < 2*dy) {
				moveRight = true;
				moveLeft = moveUp = moveDown = false;
			}
			else if (dy > 2*dx) {
				moveUp = true;
				moveRight = moveLeft = moveDown = false;
			}
			else {
				moveUp = moveRight = true;
				moveLeft = moveDown = false;
			}
			break;
		
		case 0x03:
			if (dx > 2*dy) {
				moveLeft = true;
				moveRight = moveUp = moveDown = false;
			}
			else if (dy > 2*dx) {
				moveUp = true;
				moveRight = moveLeft = moveDown = false;
			}
			else {
				moveUp = moveLeft = true;
				moveRight = moveDown = false;
			}
			break;
	};
}
