#include "triplebuffer.h"


TripleBuffer::TripleBuffer()
	:PageFlipping(),
	page3(NULL),
	page(0)
{
}

	
Error TripleBuffer::Create() {
	Destroy();
	
	if (!(gfx_capabilities & GFX_CAN_TRIPLE_BUFFER)) {
		enable_triple_buffer();
	}

	if (!(gfx_capabilities & GFX_CAN_TRIPLE_BUFFER)) {
		return Error(Error::TRIPLEBUFFER);
	}

	Error e = PageFlipping::Create();
	if (e) {
		return e;
	}
	
	page3 = create_video_bitmap(SCREEN_W, SCREEN_H);
	if (!page3) {
		Destroy();
		return Error(Error::VIDEOMEMORY);
	}
	
	return Error(Error::NONE);
}


void TripleBuffer::Destroy() {
	PageFlipping::Destroy();

	if (page3) {
		destroy_bitmap(page3);
		page3 = NULL;
	}
}


void TripleBuffer::Draw() {
	do {
	} while (poll_scroll());
	
	request_video_bitmap(active);
	
	switch (page) {
		case 0:  page = 1;  active = page2;  break;
		case 1:  page = 2;  active = page3;  break;
		case 2:  page = 0;  active = page1;  break;
	}
}
