#ifndef		GAME_H
#define		GAME_H

#include <allegro.h>
#include "params.h"
#include "error.h"
#include "fps.h"
#include "screenupdate.h"
#include "doublebuffer.h"
#include "pageflipping.h"
#include "triplebuffer.h"

class Game {
	protected:
		FPS fps;
		char gameTitle[32];
		ScreenUpdate *driver;

		virtual void Draw(BITMAP *canvas);
		virtual bool Update();

		Error SetUpdateDriver(ScreenUpdate *driver);
		BITMAP *GetCanvas() { return driver->GetCanvas(); }

	public:
		Game();
		virtual ~Game();

		virtual Error Init();
		void Run();
};

#endif		//GAME_H
