#include "fps.h"

FPS::FPS() : samples(NULL) {
	Init(0);
}


FPS::~FPS() {
	if (samples) {
		delete [] samples;
		samples = NULL;
	}
	nSamples = 0;
	frameCounter = 0;
}


void FPS::Init(int fps) {
	if (samples) {
		delete [] samples;
		samples = NULL;
	}
	nSamples = fps;
	samples = fps ? new int[nSamples] : NULL;
	for (int i=0; i<nSamples; i++) {
		samples[i] = 1;
	}
	curSample = 0;
	frameCounter = 0;
	framesPerSecond = fps;
}


void FPS::Tick() {
	curSample++;
	curSample %= nSamples;
	framesPerSecond -= samples[curSample];
	framesPerSecond += frameCounter;
	samples[curSample] = frameCounter;
	frameCounter = 0;
}


void FPS::Frame() {
	++frameCounter;
}


int FPS::Get() {
	return framesPerSecond;
}

void FPS::Draw(BITMAP *buffer) {
	text_mode(makecol(0,0,0));
	textprintf(buffer, font, 0, 0, makecol(255,255,255), "%d FPS", Get());
	text_mode(-1);
}
