#include "doublebuffer.h"
#include "params.h"


DoubleBuffer::DoubleBuffer() : ScreenUpdate(), buffer(NULL) {
}


DoubleBuffer::~DoubleBuffer() {
}

	
Error DoubleBuffer::Create() {
	Destroy();
	buffer = create_bitmap(SCREEN_W, SCREEN_H);
	if (!buffer) {
		return Error(Error::MEMORY);
	}
	else {
		clear(buffer);
		return Error(Error::NONE);
	}
}


void DoubleBuffer::Destroy() {
	if (buffer) {
		destroy_bitmap(buffer);
		buffer = NULL;
	}
}


void DoubleBuffer::Draw() {
	if (Params::vsync) {
		vsync();
	}
	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}
