#include "story.h"
#include "data.h"
#include <fstream>
using namespace std;


Story::Story() : GameScreen() {
	ifstream f;
	f.open("story", ios::in);
	
	lines.clear();
	while (f) {
		string s;
		getline(f, s);
		lines.push_back(s); 
	}
	
	f.close();
}


Story::~Story() {
	TRACE("Story::~Story()\n");
	lines.clear();
}


void Story::Draw(BITMAP *canvas) {
	blit(Data::menuBack, canvas, 0, 0, 0, 0, canvas->w, canvas->h);
	
	rectfill(canvas, 10, 80, 310, 230, makecol(8,32,24));
	rect(canvas, 10, 80, 310, 230, makecol(0,0,0));

	float dy = 20.0f;
	int r,g,b;
	if (80.0f - y < lines.size()*dy) {
		float cy = y;
		float v;
		set_clip(canvas, 10, 80, 310, 230);
		for (vector<string>::iterator i = lines.begin(); i != lines.end(); ++i) {
			if ((cy > 80.0f) && (cy < 230.0f)) {
				v = 1.0f - (float)fabs(cy - 155.0f)/75.0f;
				hsv_to_rgb(45, 0.3f, v, &r, &g, &b);
				textout_centre(canvas, font, i->c_str(), 160, (int)cy, makecol(r,g,b));
			}
			cy += dy;
		}
		set_clip(canvas, 0, 0, 319, 239);
	}
	else {
		hsv_to_rgb(45, 0.3f, 1.0f, &r, &g, &b);
		textout_centre(canvas, font, "Press enter to continue...", 160, 155, makecol(r,g,b));
	}
}


bool Story::Update() {
	y += vy;
	
	if (::key[KEY_DOWN]) {
		vy = -4.0f;
	}
	else if (::key[KEY_UP]) {
		vy = 4.0f;
	}
	else {
		vy = -0.15f;
	}
	
	if (::key[KEY_ENTER] && !key[KEY_ENTER]) {
		return true;
	}
	
	return GameScreen::Update();
}


GameState Story::NextState() {
	return previousState;
}


Error Story::Init() {
	y = 230.0f;
	vy = -0.25f;
	return GameScreen::Init();
}
