#include "soul.h"
#include "aiinput.h"
#include "camera.h"
#include "data.h"
#include "../base/params.h"

Soul::Soul() : Player() {
	if (input) {
		delete input;
		input = NULL;
	}
	
	input = new AIInput;
	((AIInput *)input)->parent = this;
	switch (Params::difficulty) {
		case 0:		hp = (float)Params::hp2/2;	break;
		case 1:		hp = (float)Params::hp2;		break;
		case 2:		hp = (float)3*Params::hp2/2;	break;
	};
	faceOffset = 0;
	tailOffset = 0;
	Init();
}


Soul::~Soul() {
	TRACE("Soul::~Soul()\n");
}


void Soul::Init() {
	v.x = (float)(rand()%256 - 128)/128.0f;
	v.y = (float)(rand()%256 - 128)/128.0f;
}
