#include "scorebubble.h"
#include "camera.h"

ScoreBubble::ScoreBubble(float x, float y, const char *text) : Object() {
	pos.x = x;
	pos.y = y;
	v.x = 0.0f;
	v.y = -2.0f;
	min.x = -1000.0f;
	min.y = -1000.0f;
	this->text = new char[ustrsizez(text)];
	ustrcpy(this->text, text);
	hp = 180;
}


ScoreBubble::~ScoreBubble() {
	delete [] text;
}


void ScoreBubble::Update() {
	Object::Update();
	--hp;
}


void ScoreBubble::Draw(BITMAP *canvas, Camera *camera) {
	int px = (int)(pos.x - camera->pos.x + camera->min.x);
	int py = (int)(pos.y - camera->pos.y + camera->min.y);
	int r,g,b;
	hsv_to_rgb(55, 1.0f, (float)hp/180.0f, &r, &g, &b);
	textprintf(canvas, font, px+1, py+1, makecol(0,0,0), text);
	textprintf(canvas, font, px, py, makecol(r,g,b), text);
}
