#ifndef		PLAYER_H
#define		PLAYER_H

#include "debug.h"
#include "object.h"
#include "input.h"
#include "particle.h"
#include <vector>
using namespace std;

class Player : public Object {
	public:
		enum State { SPAWNING, ALIVE, DYING, DEAD };
		State state;
		Input *input;
		float hp;
		int stateCounter;
		int face, prevFace;
		int faceCounter, faceTransCounter;
		int faceOffset;
		int tailOffset;
		vector<Particle> particles;
		int particleCounter;
		
		static BITMAP *tmpBmp;

	public:
		Player();
		virtual ~Player();
	
		virtual void Init();
		virtual void Update();
		virtual void Draw(BITMAP *canvas, Camera *camera);
};

#endif		//PLAYER_H
