#include "player.h"
#include "camera.h"
#include "userinput.h"
#include "data.h"
#include "../base/params.h"

BITMAP *Player::tmpBmp = NULL;

Player::Player() : Object() {
	float d = (float)Params::rad;
	min = Vector(d, d);
	max = Vector(1024 - d, 768 - d);
	input = new UserInput;
	switch (Params::difficulty) {
		case 0:		hp = (float)2*Params::hp1;		break;
		case 1:		hp = (float)Params::hp1;		break;
		case 2:		hp = (float)2*Params::hp1/3;	break;
	};
	state = SPAWNING;
	stateCounter = 0;
	face = rand()%8;
	prevFace = 0;
	faceCounter = rand()%120 + 60;
	faceTransCounter = 0;
	faceOffset = 8;
	tailOffset = 4;
	particleCounter = 0;
}


Player::~Player() {
	TRACE("Player::~Player()\n");
	if (input) {
		delete input;
	}
}


void Player::Init() {
	pos.x = 512.0f;
	pos.y = 384.0f;
	v.x = 0.0f;
	v.y = 0.0f;
	switch (Params::difficulty) {
		case 0:		hp = (float)2*Params::hp1;		break;
		case 1:		hp = (float)Params::hp1;		break;
		case 2:		hp = (float)2*Params::hp1/3;	break;
	};
	state = SPAWNING;
	stateCounter = 0;
	face = rand()%8;
	prevFace = 0;
	faceCounter = rand()%120 + 60;
	faceTransCounter = 0;
	faceOffset = 8;
	tailOffset = 4;
	particleCounter = 0;
}


void Player::Update() {
	input->Update();

	if (input->Left()) {
		v.x -= Params::acc;
	}
	else if (input->Right()) {
		v.x += Params::acc;
	}
	else {
		v.x *= Params::dec;
	}

	if (input->Up()) {
		v.y -= Params::acc;
	}
	else if (input->Down()) {
		v.y += Params::acc;
	}
	else {
		v.y *= Params::dec;
	}
	
	v.x = MID(-4.0f, v.x, 4.0f);
	v.y = MID(-4.0f, v.y, 4.0f);

	pos.x += v.x;
	if (pos.x >= max.x || pos.x < min.x) {
		pos.x -= v.x;
		v.x = -v.x*0.25f;
	}
	
	pos.y += v.y;
	if (pos.y >= max.y || pos.y < min.y) {
		pos.y -= v.y;
		v.y = -v.y*0.25f;
	}
	
	if (state == DYING) {
		--stateCounter;
		if (stateCounter <= 0) {
			state = DEAD;
		}
	}
	else if (state == SPAWNING) {
		++stateCounter;
		if (stateCounter >= 60) {
			state = ALIVE;
		}
	}
	
	if (faceTransCounter > 0) {
		--faceTransCounter;
	}
	--faceCounter;
	if (faceCounter <= 0) {
		prevFace = face;
		faceTransCounter = 60;
		face = rand()%8;
		faceCounter = rand()%120 + 60;
	}

	if (particles.size() < Params::maxParticles && particleCounter == 0) {
		particles.push_back(Particle(pos.x, pos.y, (float)(rand()%255-128)/512.0f, (float)(rand()%255-128)/512.0f));
		particleCounter = 3;
	}
	if (particleCounter > 0) {
		--particleCounter;
	}
	
	vector<Particle>::iterator i;
	for (i = particles.begin(); i != particles.end(); ) {
		if (i->life <= 0) {
			i = particles.erase(i);
		}
		else {
			i->Update();
			++i;
		}
	}
}


void Player::Draw(BITMAP *canvas, Camera *camera) {
	if (!tmpBmp) {
		tmpBmp = create_bitmap(Params::rad*2, Params::rad*2);
	}

	if (state == ALIVE) {
		int s = Params::rad;
		int x = (int)(pos.x - camera->pos.x + camera->min.x) - s;
		int y = (int)(pos.y - camera->pos.y + camera->min.y) - s;
		
		// draw the particles (tail)
		vector<Particle>::iterator i;
		for (i = particles.begin(); i != particles.end(); ++i) {
			set_trans_blender(255,255,255, i->trans);
			draw_trans_sprite(canvas, Data::tail[(face%4)+tailOffset], (int)(i->x - camera->pos.x + camera->min.x) - s, (int)(i->y - camera->pos.y + camera->min.y) - s);
		}
		
		// draw the face
		if (faceTransCounter > 0) {
			set_trans_blender(255,255,255, faceTransCounter*4);
			draw_trans_sprite(canvas, Data::face[prevFace+faceOffset], x, y);
		}
		set_trans_blender(255,255,255, 240 - faceTransCounter*4);
		draw_trans_sprite(canvas, Data::face[face+faceOffset], x, y);
	}
	else {
		int s = stateCounter*Params::rad/60;
		int x = (int)(pos.x - camera->pos.x + camera->min.x);
		int y = (int)(pos.y - camera->pos.y + camera->min.y);

		// draw the particles (tail)
		vector<Particle>::iterator i;
		for (i = particles.begin(); i != particles.end(); ++i) {
			clear_to_color(tmpBmp, makecol(255,0,255));
			stretch_sprite(tmpBmp, Data::tail[(face%4)+tailOffset], Params::rad - s, Params::rad - s, s*2, s*2);
			set_trans_blender(255,255,255, i->trans);
			draw_trans_sprite(canvas, tmpBmp, (int)(i->x - camera->pos.x + camera->min.x) - Params::rad, (int)(i->y - camera->pos.y + camera->min.y) - Params::rad);
		}

		if (faceTransCounter > 0) {
			clear_to_color(tmpBmp, makecol(255,0,255));
			stretch_sprite(tmpBmp, Data::face[prevFace+faceOffset], Params::rad - s, Params::rad - s, s*2, s*2);
			set_trans_blender(255,255,255, faceTransCounter*4);
			draw_trans_sprite(canvas, tmpBmp, x - Params::rad, y - Params::rad);
		}
		clear_to_color(tmpBmp, makecol(255,0,255));
		stretch_sprite(tmpBmp, Data::face[face+faceOffset], Params::rad - s, Params::rad - s, s*2, s*2);
		set_trans_blender(255,255,255, 240 - faceTransCounter*4);
		draw_trans_sprite(canvas, tmpBmp, x - Params::rad, y - Params::rad);
	}
}
