#include "menu.h"
#include "menuitemtoggle.h"

MenuItemToggle::MenuItemToggle(const char *text, GameState nextState, int y, int *value)
	: MenuItem(text, nextState, y) 
{
	this->value = value;
}


MenuItemToggle::~MenuItemToggle() {
}


void MenuItemToggle::Draw(BITMAP *canvas) {
	char *tmp = new char[ustrsizez(text) + 8];
	if (*value == 1) {
		usprintf(tmp, "%s - on", text);
	}
	else {
		usprintf(tmp, "%s - off", text);
	}
	char *tmp2 = tmp;
	tmp = text;
	text = tmp2;
	MenuItem::Draw(canvas);
	text = tmp;
	tmp = tmp2;
	delete [] tmp;
}


void MenuItemToggle::Update() {
	MenuItem::Update();
	
	if (TestFlag(ITEM_SELECTED)) {
		if (::key[KEY_ENTER] && !parent->key[KEY_ENTER]) {
			if (*value == 1) {
				*value = 0;
			}
			else {
				*value = 1;
			}
		}
	}
}
