#include "menu.h"
#include "data.h"
#include "../base/params.h"
#include "menuitemslider.h"

MenuItemSlider::MenuItemSlider(const char *text, GameState nextState, int y, int *value, int nOptions, int *options, char **optionNames)
	: MenuItemToggle(text, nextState, y, value) 
{
	int i;
	this->nOptions = nOptions;
	this->options = new int[nOptions];
	this->optionNames = new char*[nOptions];
	for (i=0; i<nOptions; i++) {
		this->options[i] = options[i];
		this->optionNames[i] = new char[ustrsizez(optionNames[i])];
		ustrcpy(this->optionNames[i], optionNames[i]);
	}
}


MenuItemSlider::~MenuItemSlider() {
	delete [] options;
	for (int i=0; i<nOptions; i++) {
		delete [] optionNames[i];
		optionNames[i] = NULL;
	}
	delete [] optionNames;
}


void MenuItemSlider::Draw(BITMAP *canvas) {
	char *tmp = new char[ustrsizez(text) + ustrsizez(optionNames[progress]) + 4];
	usprintf(tmp, "%s - %s", text, optionNames[progress]);
	char *tmp2 = tmp;
	tmp = text;
	text = tmp2;
	MenuItem::Draw(canvas);
	text = tmp;
	tmp = tmp2;
	delete [] tmp;
}


void MenuItemSlider::Update() {
	MenuItem::Update();

	progress = 0;
	for (int i=0; i<nOptions; i++) {
		if (*value == options[i]) {
			progress = i;
			break;
		}
	}

	if (TestFlag(ITEM_SELECTED)) {
		if ((::key[KEY_ENTER] && !parent->key[KEY_ENTER]) || (::key[KEY_RIGHT] && !parent->key[KEY_RIGHT])) {
			if ((::key[KEY_RIGHT] && !parent->key[KEY_RIGHT])) {
				play_sample(Data::select, Params::volSound, 128, 1000, 0);
			}
			progress++;
			if (progress >= nOptions) progress = nOptions-1;
			*value = options[progress];
		}
		else if ((::key[KEY_BACKSPACE] && !parent->key[KEY_BACKSPACE]) || (::key[KEY_LEFT] && !parent->key[KEY_LEFT])) {
			play_sample(Data::select, Params::volSound, 128, 1000, 0);
			progress--;
			if (progress < 0) progress = 0;
			*value = options[progress];
		}
	}
}
