#include "menuitemedit.h"

MenuItemEdit::MenuItemEdit(const char *text, GameState nextState, int y) : MenuItem(text, nextState, y) {
	cur = 0;
	counter = 0;
}


MenuItemEdit::~MenuItemEdit() {
}


void MenuItemEdit::Draw(BITMAP *canvas) {
	int tw = text_length(font, "A");
	int w = 8*tw + 8;
	int x = (SCREEN_W - w)/2;
	int h = text_height(font) + 6;
	int y2 = y-3;
	rectfill(canvas, x, y2, x+w-1, y2+h-1, makecol(0,0,0));
	MenuItem::Draw(canvas);
	if ((counter/10)%2) {
		vline(canvas, x + 4 + cur*tw, y2 + 3, y2 + h - 5, makecol(220,210,160));
	}
}


void MenuItemEdit::Update() {
	MenuItem::Update();

	counter++;
	counter %= 20;
	
	if (keypressed()) {
		int cc = readkey();
		if ((cc >> 8) == KEY_BACKSPACE) {
			if (cur > 0) {
				--cur;
				text[cur] = ' ';
			}
		}
			
		if (cur < 8) {
			int c = cc & 0xFF;
			if ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9')) {
				text[cur] = c;
				++cur;
			}
		}
		clear_keybuf();
	}
}
