#ifndef		MENUITEM_H
#define		MENUITEM_H

#include "debug.h"
#include "gamescreen.h"

#define		ITEM_SELECTED	1
#define		ITEM_DISABLED	2

class Menu;
class MenuItem {
	protected:
		char *text;
		GameState nextState;
		int y, flags;
		Menu *parent;
		int valCounter;
		void SetFlag(int f);
		void ClearFlag(int f);
		bool TestFlag(int f);

	public:
		MenuItem(const char *text, GameState nextState, int y);
		virtual ~MenuItem();

		virtual void Draw(BITMAP *canvas);
		virtual void Update();
		virtual GameState NextState();
		virtual void Select();
		virtual void Deselect();
		virtual void Disable();
		int GetY() { return y; }
		char *GetText() { return text; }
		
		friend class Menu;
};

#endif		//MENU_H
