#include "menuitem.h"

MenuItem::MenuItem(const char *text, GameState nextState, int y) {
	this->text = new char[ustrsizez(text)];
	ustrcpy(this->text, text);
	this->nextState = nextState;
	this->y = y;
	flags = 0;
	valCounter = 0;
}


MenuItem::~MenuItem() {
	TRACE("MenuItem::~MenuItem()\n");
	delete [] text;
}


void MenuItem::Draw(BITMAP *canvas) {
	textout_centre(canvas, font, text, SCREEN_W/2+1, y+1, makecol(0,0,0));
	int col = 0;
	if (TestFlag(ITEM_DISABLED)) {
		col = makecol(140,140,140);
	}
	else {
		if (TestFlag(ITEM_SELECTED)) {
			int r,g,b;
			float v = (float)valCounter;
			if (v < 30.0f) {
				v = 60.0f - v;
			}
			v += 60.0f;
			v /= 120.0f;
			
			hsv_to_rgb(45.0f, 0.4f, v, &r,&g,&b);
			col = makecol(r,g,b);
		}
		else {
			col = makecol(190,150,84);
		}
	}

	textout_centre(canvas, font, text, SCREEN_W/2, y, col);
}


void MenuItem::Update() {
	valCounter++;
	valCounter %= 60;
}


GameState MenuItem::NextState() {
	return nextState;
}


void MenuItem::Select() {
	SetFlag(ITEM_SELECTED);
}


void MenuItem::Deselect() {
	ClearFlag(ITEM_SELECTED);
}


void MenuItem::Disable() {
	SetFlag(ITEM_DISABLED);
}


void MenuItem::SetFlag(int f) {
	flags |= f;
}


void MenuItem::ClearFlag(int f) {
	flags &= ~f;
}


bool MenuItem::TestFlag(int f) {
	return (flags & f);
}
