#include "menu.h"
#include "data.h"
#include "../base/params.h"

static BITMAP *tmpBmp = NULL;

void Menu::Draw(BITMAP *canvas) {
	blit(Data::menuBack, canvas, 0, 0, 0, 0, canvas->w, canvas->h);

	int th = text_height(font);
	int y = items[0]->GetY() - th;
	int h = items[items.size()-1]->GetY() + 2*th - y;
	
	std::vector<MenuItem *>::iterator i;
	int w = 0;
	for (i = items.begin(); i != items.end(); ++i) {
		w = MAX(text_length(font, (*i)->GetText()), w);
	}
	w += 80;
	int x = (SCREEN_W - w)/2;
	
	if (!tmpBmp || tmpBmp->w != w || tmpBmp->h != h) {
		if (tmpBmp) {
			destroy_bitmap(tmpBmp);
		}
		tmpBmp = create_bitmap(w, h);
		clear_to_color(tmpBmp, makecol(64,96,80));
		rect(tmpBmp, 0, 0, w-1, h-1, makecol(0,0,0));
	}
	
	set_trans_blender(0,0,0,128);
	draw_trans_sprite(canvas, tmpBmp, x, y);
	
	for (i = items.begin(); i != items.end(); ++i) {
		(*i)->Draw(canvas);
	}
}


bool Menu::Update() {
	for (std::vector<MenuItem *>::iterator i = items.begin(); i != items.end(); ++i) {
		(*i)->Update();
	}
	
	if (::key[KEY_ENTER] && !key[KEY_ENTER]) {
		play_sample(Data::select, Params::volSound, 128, 1000, 0);
		return true;
	}

	unsigned int oldSelectedItem = selectedItem;
	if (::key[KEY_UP] && !key[KEY_UP]) {
		int newSel = selectedItem;
		while (true) {
			--newSel;
			if (newSel < 0) {
				break;
			}
			else if (!items[newSel]->TestFlag(ITEM_DISABLED)) {
				selectedItem = newSel;
				break;
			}
		}
	}

	if (::key[KEY_DOWN] && !key[KEY_DOWN]) {
		int newSel = selectedItem;
		while (true) {
			++newSel;
			if (newSel > items.size()-1) {
				break;
			}
			else if (!items[newSel]->TestFlag(ITEM_DISABLED)) {
				selectedItem = newSel;
				break;
			}
		}
	}
	
	if (oldSelectedItem != selectedItem) {
		play_sample(Data::collect, Params::volSound, 128, 1000, 0);
		items[oldSelectedItem]->Deselect();
		items[selectedItem]->Select();
	}

	return GameScreen::Update();
}


Menu::Menu() : GameScreen(), selectedItem(0) {
}


Menu::~Menu() {
	TRACE("Menu::~Menu()\n");
	Clear();
	
	if (tmpBmp) {
		destroy_bitmap(tmpBmp);
		tmpBmp = NULL;
	}
}


void Menu::Clear() {
	while (!items.empty()) {
		MenuItem *i = items.back();
		delete i;
		items.pop_back();
	}
}


Error Menu::Init() {
	Error e;
	if (e = GameScreen::Init()) return e;

	int i;
	for (i=0; i<items.size(); i++) {
		items[i]->Deselect();
	}
	for (i=0; i<items.size(); i++) {
		if (!items[i]->TestFlag(ITEM_DISABLED)) {
			items[i]->Select();
			selectedItem = i;
			break;
		}
	}
	return e;
}


GameState Menu::NextState() {
	return ::key[KEY_ESC] ? previousState : items[selectedItem]->NextState();
}


void Menu::AddItem(MenuItem *i) {
	items.push_back(i);
	i->parent = this;
}


MenuItem *Menu::GetSelectedItem() {
	return items[selectedItem];
}
