#include "gamescreen.h"

GameScreen::GameScreen() {
	ResetInputState();
	previousState = QUIT_PROGRAM;
}


GameScreen::~GameScreen() {
	TRACE("GameScreen::~GameScreen()\n");
}


GameState GameScreen::NextState() {
	return QUIT_PROGRAM;
}


Error GameScreen::Init() {
	Error e = Error(Error::NONE);
	return e;
}


void GameScreen::Draw(BITMAP *canvas) {
	clear(canvas);
}


bool GameScreen::Update() {
	if (::key[KEY_ESC] && !key[KEY_ESC]) {
		return true;
	}
	else {
		ResetInputState();
		return false;
	}
}


void GameScreen::ResetInputState() {
	for (int i=0; i<256; i++) {
		key[i] = ::key[i];
	}
}
